/*
  decode_ftp.c

  File Transfer Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_ftp.c,v 1.3 2000/06/17 19:42:24 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "options.h"
#include "decode.h"

int
decode_ftp(u_char *buf, int len)
{
	char *p;
	
	Buf[0] = '\0';
	
	if ((len = strip_telopts(buf, len)) == 0)
		return (0);

	if (!is_ascii_string(buf, len))
		return (0);
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (strncasecmp(p, "USER ", 5) == 0 ||
		    strncasecmp(p, "ACCT ", 5) == 0 ||
		    strncasecmp(p, "PASS ", 5) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	if (strip_lines(Buf, Opt_lines) < 2)
		return (0);
	
	return (strlen(Buf));
}

