/*
  decode_yppasswd.c

  RPC yppasswd.

  Totally untested, i don't run YP. Let me know if this works. :-)

  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_yppasswd.c,v 1.2 2000/05/17 08:12:56 dugsong Exp $
*/

#include <sys/types.h>
#include <sys/param.h>
#include <rpc/rpc.h>
#include <rpcsvc/yppasswd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rpc.h"
#include "decode.h"

/* XXX - <rpcsvc/yppasswd.x> varies on different systems :-( */

struct my_passwd {
	char   *pw_name;
	char   *pw_passwd;
	int	pw_uid;
	int	pw_gid;
	char   *pw_gecos;
	char   *pw_dir;
	char   *pw_shell;
};

struct my_yppasswd {
	char   *oldpass;
	struct my_passwd newpw;
};

static bool_t
xdr_my_passwd(XDR *xdrs, struct my_passwd *objp)
{
	if (xdr_string(xdrs, &objp->pw_name, ~0) &&
	    xdr_string(xdrs, &objp->pw_passwd, ~0) &&
	    xdr_int(xdrs, &objp->pw_uid) &&
	    xdr_int(xdrs, &objp->pw_gid) &&
	    xdr_string(xdrs, &objp->pw_gecos, ~0) &&
	    xdr_string(xdrs, &objp->pw_dir, ~0) &&
	    xdr_string(xdrs, &objp->pw_shell, ~0))
		return (TRUE);

	return (FALSE);
}

static bool_t
xdr_my_yppasswd(XDR *xdrs, struct my_yppasswd *objp)
{
	if (xdr_string(xdrs, &objp->oldpass, ~0) &&
	    xdr_my_passwd(xdrs, &objp->newpw))
		return (TRUE);
	
	return (FALSE);
}

int
decode_yppasswd(u_char *buf, int len)
{
	struct rpc_msg msg;
	struct my_yppasswd yp;
	XDR xdrs;
	int hdrlen;
	
	memset(&msg, 0, sizeof(msg));
	
	if ((hdrlen = rpc_decode(buf, len, &msg)) == 0)
		return (0);
	
	if (msg.rm_direction == CALL &&
	    msg.rm_call.cb_prog == YPPASSWDPROG &&
	    msg.rm_call.cb_proc == YPPASSWDPROC_UPDATE) {
		xdrmem_create(&xdrs, buf + hdrlen, len - hdrlen, XDR_DECODE);
		if (!xdr_my_yppasswd(&xdrs, &yp)) {
			xdr_destroy(&xdrs);
			return (0);
		}
		snprintf(Buf, sizeof(Buf),
			 "%s\n%s:%s:%d:%d:%s:%s:%s\n",
			 yp.oldpass, yp.newpw.pw_name, yp.newpw.pw_passwd,
			 yp.newpw.pw_uid, yp.newpw.pw_gid, yp.newpw.pw_gecos,
			 yp.newpw.pw_dir, yp.newpw.pw_shell);
		
		return (strlen(Buf));
	}
	return (0);
}
