/*
  decode_mountd.c

  RPC mountd.

  Outputs filehandle in nfsshell format. :-)
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_mountd.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <sys/param.h>
#include <rpc/rpc.h>
#include <rpcsvc/mount.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rpc.h"
#include "decode.h"

int
decode_mountd(u_char *buf, int len)
{
	struct rpc_msg msg;
	struct xid_map *xm;
	char *dir, *fh;
	int i, hdrlen, dirlen, fhlen;
	
	memset(&msg, 0, sizeof(msg));
	
	if ((hdrlen = rpc_decode(buf, len, &msg)) == 0)
		return (0);
	
	if (msg.rm_direction == CALL &&
	    msg.rm_call.cb_prog == MOUNTPROG &&
	    msg.rm_call.cb_proc == MOUNTPROC_MNT &&
	    len - hdrlen > 5) {
		dirlen = ntohl(*(u_long *)(buf + hdrlen));
		
		if (dirlen > MAXPATHLEN || (dir = malloc(dirlen + 1)) == NULL)
			return (0);
		
		strlcpy(dir, buf + hdrlen + 4, dirlen + 1);
		
		xid_map_enter(msg.rm_xid, MOUNTPROG, (void *) dir);
	}
	else if (msg.rm_direction == REPLY &&
		 (xm = xid_map_find(msg.rm_xid)) != NULL) {
		if (msg.rm_reply.rp_stat == MSG_ACCEPTED &&
		    msg.acpted_rply.ar_stat == SUCCESS &&
		    len - hdrlen >= 40 &&
		    ntohl(*(u_long *)(buf + hdrlen)) == 0) {
			snprintf(Buf, sizeof(Buf), "%s [", (char *)xm->data);
			
			fh = Buf + strlen(Buf);
			buf += hdrlen + 4;
			
			if ((fhlen = ntohl(*(u_long *)buf)) <= 64) {
				buf += 4;
				for (i = 0; i < fhlen; i++)
					sprintf(fh + (i * 3), "%.2x ", buf[i]);
				fh[(i * 3) - 1] = '\0';
				strlcat(Buf, "]\n", sizeof(Buf));
				
				return (strlen(Buf));
			}
		}
		free(xm->data);
		memset(xm, 0, sizeof(*xm));
	}
	return (0);
}
