/*
  decode_ftp.c

  File Transfer Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_ftp.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "options.h"
#include "decode.h"

int
decode_ftp(u_char *buf, int len)
{
	char *p;
	
	Buf[0] = '\0';

	if (!strip_telopts(buf, len))
		return (0);
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (strncasecmp(p, "USER ", 5) == 0 ||
		    strncasecmp(p, "ACCT ", 5) == 0 ||
		    strncasecmp(p, "PASS ", 5) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	if (strip_lines(Buf, Opt_lines) < 2)
		return (0);
	
	return (strlen(Buf));
}

