/*
  decode_aim.c

  AOL Instant Messenger.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_aim.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "hex.h"
#include "decode.h"

/* XXX - need to investigate AOL's FLAP, SNAC layers more... */
int
decode_aim(u_char *buf, int len)
{
	static char *aim_xor = "Tic/Toc";
	int i, j;
	char *p;
	
	Buf[0] = '\0';
	
	if ((p = bufbuf(buf, len, "toc_signon ", 11)) == NULL)
		return (0);
	
	i = 0;
	for (p = strtok(p, " "); p != NULL; p = strtok(NULL, " ")) {
		strlcat(Buf, p, sizeof(Buf));
		strlcat(Buf, " ", sizeof(Buf));
		if (++i > 4) break;
	}
	if (p == NULL)
		return (0);
	
	strlcat(Buf, "[", sizeof(Buf));
	
	j = hex_decode(p + 2, p, strlen(p));
	for (i = 0; i < j; i++)
		p[i] = p[i] ^ aim_xor[i % 7];
	p[j] = '\0';
	strlcat(Buf, p, sizeof(Buf));
	
	strlcat(Buf, "]\n", sizeof(Buf));
	
	len = strlen(Buf);
	
	if (!is_ascii_string(Buf, len))
		return (0);
	
	return (len);
}

