/*
  asn1.c
 
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
  
  $Id: asn1.c,v 1.1 2000/05/16 17:31:13 dugsong Exp $
*/

#include <sys/types.h>
#include <arpa/nameser.h>

int
asn1_type(u_char **buf)
{
	u_char *p = *buf;
	int i;
	
	i = *p++ & 0x1f;
	*buf = p;
	
	return (i);
}

int
asn1_len(u_char **buf)
{
	u_char *p;
	int len, num = 0;
	
	p = *buf;
	
	if (*p >= 128) {	/* Long form */
		len = *p++ & ~128;
		
		if (len == 1) {
			num = *p++;
		}
		else if (len == 2) {
			GETSHORT(num, p);
		}
		else if (len == 3) {
			p--; GETLONG(num, p);
			num &= 0xFFF;
		}
		else if (len== 4)
			GETLONG(num, p);
	}
	else num = *p++;	/* Short form */
	
	*buf = p;
	
	return (num);
}

