/* root.c
 * contains the root nameservers in a t_rr struct
 * The struct is global
 *
 * (c) NLnet Labs 2004
 *
 * See the file LICENSE for the license
 */

#include "common.h"

struct t_rr *root_servers;

/**
 * Fills the root nameserver list
 */
int 
fill_root(void)
{
	struct t_rdata *rdata_root = rdata_create((uint8_t*)".",1);       
        root_servers = ns_create(rdata_root,
		(uint8_t*) A_ROOT, TYPE_A); /* A root */
	rdata_destroy(rdata_root);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.228.79.201", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.33.4.12", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"128.8.10.90", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.203.230.10", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.5.5.241", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.112.36.4", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"128.63.2.53", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.36.148.17", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"192.58.128.30", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"193.0.14.129", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"198.32.64.12", TYPE_A);
	root_servers = ns_add_ip(root_servers,(uint8_t*)"202.12.27.33", TYPE_A);
	return RET_SUC;
}
