/** 
 * query.c
 * handle a query
 * 
 * (c) NLnet Labs, 2004
 * 
 * See the file LICENSE for the license
 */ 

#include "common.h"

int
query(struct t_rr *q, struct t_rr *nameserver, int protocol)
{
	struct t_dpacket *p = NULL;
	struct t_dpacket *reply_packet = NULL;
	int socket = 0;
	int result;

	if (drill_opt->purpose == ANSWERFROMFILE) {
		/* get answer from file */
		reply_packet = file_packet(drill_opt->answerfile);
	} else {
		p = dpacket_create();
		SET_CD(p); /* CD BIT XXX */

		dpacket_add_rr(rr_clone(q, FOLLOW), SEC_QUESTION, p);

		/* OPT stuff */
		SET_UDPSIZE(p, drill_opt->bufsize);
		if (drill_opt->dnssec == 1)
			SET_DNSSEC(p);

		if (drill_opt->purpose == DUMPQUERY) {
			result = packet2file(p, drill_opt->filename);
			/* what happens with result ??? */
		}

		/* AXFR */
		if (drill_opt->type == TYPE_AXFR) {
			protocol = PROTO_TCP;
			drill_opt->debug=1;
			result = axfr(p, nameserver);
			dpacket_destroy(p);
			return result;
		}

		/* set the RD bit if disired */
		if (1 == drill_opt->recurse) 
			SET_RD(p);

		/* from the net */
        	reply_packet = send_packet(p, nameserver, protocol, &socket);

		if (protocol == PROTO_TCP) 
			close(socket);


	        dpacket_destroy(p);
	}

        /* if reply packet is null resend query
         * with EDNS0 */

        if (reply_packet) {
		prettyprint_packet(reply_packet);
                result = RET_SUCCESS;

                if (drill_opt->answerfile) {
                	result = packet2file(reply_packet, drill_opt->answerfile);
                	drill_opt->answerfile = NULL;
                }

                dpacket_destroy(reply_packet);
        } else {
                error("No response from server");
                result = RET_FAIL;
        }
        
	return result;
}
