/* dnssec.h 
 *
 * contains defines usefull in a dnssec world
 *
 * (c) NLnet Labs, 2004
 * 
 * See the file LICENSE for the license
 *
 */

#ifndef _DNSSEC_H
#define _DNSSEC_H

/* DNSKEY specific defines */
#define KEY_RSA		5
#define KEY_DSA 	3
#define KEY_PROT	3
#define KEY_FLAG	256

#define ALG_RSAMD5	1
#define ALG_DH		2
#define ALG_DSA		3
#define ALG_ECC		4
#define ALG_RSASHA1	5
#define	ALG_INDIRECT	252
#define ALG_PRIVATEDNS	253
#define ALG_PRIVATEOID	254


#define ALG_TYPES {             	\
	{ALG_RSAMD5, "RSAMD5"}, 	\
	{ALG_DH, "DH"},   		\
	{ALG_DSA, "DSA"},       	\
	{ALG_ECC, "ECC"},		\
	{ALG_RSASHA1, "RSASHA1"},	\
	{ALG_INDIRECT, "INDIRECT"},	\
	{ALG_PRIVATEDNS, "PRIVATEDNS"},	\
	{ALG_PRIVATEOID, "PRIVATEOID"},	\
	{0      , NULL}         	\
}

#define CERT_PKIX		1
#define	CERT_SPKI		2
#define	CERT_PGP		3
#define CERT_URI		253
#define	CERT_OID		254

#define CERT_TYPES {		\
	{CERT_PKIX, "PKIX"},	\
	{CERT_SPKI, "SPKI"},	\
	{CERT_PGP,  "PGP"},	\
	{CERT_URI,  "PRIVATEURI"}, \
	{CERT_OID,  "PRIVATEOID"}, \
	{0	 ,   NULL}	\
}


#define ALG_TYPES {             	\
		{ALG_RSAMD5, "RSAMD5"}, 	\
		{ALG_DH, "DH"},   		\
		{ALG_DSA, "DSA"},       	\
		{ALG_ECC, "ECC"},		\
		{ALG_RSASHA1, "RSASHA1"},	\
		{ALG_INDIRECT, "INDIRECT"},	\
		{ALG_PRIVATEDNS, "PRIVATEDNS"},	\
		{ALG_PRIVATEOID, "PRIVATEOID"},	\
		{0      , NULL}         	\
}

/** 
 * Holds an openssl key.
 */
struct t_sslkey {
	union {
		RSA	*rsa;
		DSA	*dsa;
	} key;
};

/**
 * Holds a list of zone names (for instance the must-be-secure zones).
 */
struct zone_list {
	/** Number of entries. */
	int size;
	/** Array of zone names */
	char **zones;
};

#define MAX_SEC_ZONES 1000
struct zone_list *zone_list_create(void);
void zone_list_destroy(struct zone_list *);
int add_zone_list(struct zone_list *, const char *);
int remove_zone_list(struct zone_list *, const char *);
void print_zone_list(struct zone_list *);
int contains_zone_list(struct zone_list *, const char *);
/* RRSIG helper functions */
struct t_rdata *get_signer_nme(struct t_rr *);
uint16_t get_keyid(struct t_rr *);
uint16_t get_typecovered(struct t_rr *);
struct t_rr *dpacket_get_rrsig(struct t_rr *, struct t_dpacket *);

extern struct gtab dnssec_algos[];
extern struct gtab cert_types[];

#endif /* _DNSSEC_H */
