/* 
 * cache.h
 *
 * Header file for cache.c
 *
 * for the license see LICENSE
 *
 * (c) NLnet Labs, 2004
 * 
 */


/* we should be implemented here
 * - push, put something in the cache
 * - pop,  retrieve latest pushed item
 * - search, look for an item
 * - rm, remove an specific item
 *
 * Cache is like a mathematical set, no duplicates are allowed
 * the internal implemention right now it's a double linked list.
 * This will change in future
 */

struct t_cache {
	/* rr themselves are single linked lists */
	struct t_rr *rr;
	struct t_cache *prev;
	struct t_cache *next;
};


struct t_cache * cache_new(void);
struct t_cache * cache_new_from_rr(struct t_rr *);
struct t_cache * cache_push(struct t_cache *, struct t_rr *) ;
struct t_cache * cache_pop(struct t_cache *, struct t_rr *);
struct t_cache * cache_rm_name(struct t_cache *, struct t_rdata *);
struct t_cache * cache_rm_type(struct t_cache *, uint16_t);
void cache_print(struct t_cache *);
struct t_rr * cache_search_name(struct t_cache *, struct t_rdata *);
struct t_rr * cache_search_type(struct t_cache *, uint16_t);
