/*
 * bits.h
 *
 * Convenience functions for bit manipulations
 *
 * (c) NLnet Labs, 2004
 * 
 * See the file LICENSE for the license
 *
 */

#ifdef HAVE_ENDIAN_H
#define BYTE_ORDER __BYTE_ORDER
#define LITTLE_ENDIAN __LITTLE_ENDIAN
#define BIG_ENDIAN __BIG_ENDIAN
#endif

uint8_t bitval(unsigned short bitnr);
void swap_bit(uint8_t *byte, unsigned short bitnr);
uint8_t get_bit (uint8_t *byte, unsigned short bitnr);
unsigned int bit_set (uint8_t *byte, unsigned short bitnr);
void set_bit (uint8_t *byte, unsigned short bitnr, unsigned int value);
uint8_t get_bits (uint8_t *byte, unsigned short from, unsigned short to);
void set_bits (uint8_t *byte, uint8_t set_to, unsigned short from, unsigned short to);
void print_bits (uint8_t *byte, int offset, int size, int len);
void print_bytes (uint8_t *byte, int offset, int size, int len);
void print_bytes_hex (uint8_t *byte, int offset, int size, int len);
void fprint_bytes_hex (FILE *file, uint8_t *byte, int offset, int size, int len);
char *base64_decode(unsigned char *bbuf, int strlen, size_t *result_len);
unsigned char *base64_encode(unsigned char *buf, int len);
size_t hexstr2bin(char *, int, uint8_t *, size_t, size_t);
char *bin2hexstr(uint8_t *, int);
int ipv42bin(const char *, uint8_t *);
int ipv62bin(const char *, uint8_t *);
char *bin2ipv4(uint8_t *);
char *bin2ipv6(uint8_t *);
int int2bin(unsigned int integer, uint8_t *array);

