/* Copyright (c) 2002-2008 Dovecot authors, see the included COPYING file */

#include "common.h"
#include "ostream.h"
#include "commands.h"

bool cmd_logout(struct client_command_context *cmd)
{
	struct client *client = cmd->client;

	client_send_line(client, "* BYE Logging out");
	o_stream_uncork(client->output);

	if (client->mailbox != NULL) {
		/* this could be done at client_disconnect() as well,
		   but eg. mbox rewrite takes a while so the waiting is
		   better to happen before "OK" message. */
		mailbox_close(&client->mailbox);
	}

	client_send_tagline(cmd, "OK Logout completed.");
	client_disconnect(client, "Logged out");
	return TRUE;
}
