/*
**  Copyright (c) 2005-2007 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef _DKIM_TABLES_H_
#define _DKIM_TABLES_H_

#ifndef lint
static char dkim_tables_h_id[] = "@(#)$Id: dkim-tables.h,v 1.11 2007/08/09 07:22:17 msk Exp $";
#endif /* !lint */

/* structures */
struct nametable
{
	const char *	tbl_name;	/* name */
	const int	tbl_code;	/* code */
};

struct chartable
{
	const int	tbl_char;	/* character */
	const int	tbl_code;	/* code */
};

/* tables */
struct chartable *keyparams;
struct chartable *policyflags;

struct nametable *algorithms;
struct nametable *canonicalizations;
struct nametable *hashes;
struct nametable *keytypes;
struct nametable *policies;
struct nametable *policyparams;
struct nametable *policyresults;
struct nametable *querytypes;
struct nametable *results;
struct nametable *settypes;
struct nametable *sigerrors;
struct nametable *sigparams;

/* prototypes */
extern const char *dkim_code_to_name __P((struct nametable *tbl,
                                          const int code));
extern const int dkim_name_to_code __P((struct nametable *tbl,
                                        const char *name));

extern const int dkim_code_to_char __P((struct chartable *tbl,
                                        const int code));
extern const int dkim_char_to_code __P((struct chartable *tbl,
                                        const int code));

#endif /* _DKIM_TABLES_H_ */
