/*
**  Copyright (c) 2005, 2006 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef lint
static char manual_c_id[] = "@(#)$Id: manual.c,v 1.1 2006/09/16 22:59:57 msk Exp $";
#endif /* !lint */

#ifdef AR_RES_MANUAL

/* system includes */
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#ifdef DARWIN
# include <arpa/nameser.h>
#endif /* DARWIN */
#include <resolv.h>
#include <netdb.h>
#include <assert.h>

/* macros */
#ifndef _PATH_RESCONF
# define _PATH_RESCONF	"/etc/resolv.conf"
#endif /* ! _PATH_RESCONF */
#ifndef RES_RETRY
# define RES_RETRY	4
#endif /* ! RES_RETRY */
#ifndef RES_TIMEOUT
# define RES_TIMEOUT	5
#endif /* ! RES_TIMEOUT */

#define BUFRSZ		1024

#define	SERVICE		"domain"
#define	PROTOCOL	"udp"

/*
**  AR_RES_MANUAL -- res_init()/res_ninit() replacement for systems that
**                   don't follow the de facto standards (e.g. OpenBSD 3.7)
**
**  Parameters:
**  	out -- pointer to a struct __res_state which we'll populate with
**  	       real values
**
**  Return value:
**  	0 on success, -1 on failure.
**
**  Notes:
**  	This only populates some of the _res structure, i.e. those fields
**  	required by this library.  It could easily be extended to do the
**  	whole thing though, and thus be generally useful.  Or you could just
**  	use the res_init() source code from the ISC or the single-threaded
**  	implementation of res_init() from your favourite operating system.
*/

int
ar_res_manual(struct __res_state *out)
{
	int data;
	int nscount = 0;
	FILE *f;
	char *p;
	char *q;
	char *r;
	struct servent *srv;
	char buf[BUFRSZ];

	assert(out != NULL);

	memset(out, '\0', sizeof(struct __res_state));

	srv = getservbyname(SERVICE, PROTOCOL);
	if (srv == NULL)
		return -1;

	f = fopen(_PATH_RESCONF, "r");
	if (f == NULL)
		return -1;

	clearerr(f);
	while (fgets(buf, sizeof buf, f) != NULL)
	{
		/* chomp at \n, #, or ; */
		for (p = buf; *p != '\0'; p++)
		{
			if (*p == '\n' || *p == ';' || *p == '#')
			{
				*p = '\0';
				break;
			}
		}

		/* now eat leading and trailing spaces */
		data = 0;
		r = NULL;
		for (p = buf, q = buf; *p != '\0'; p++)
		{
			if (data == 0 && isascii(*p) && isspace(*p))
				continue;

			data = 1;
			*q = *p;
			if (!(isascii(*p) && isspace(*p)))
				r = q;
			q++;
		}
		if (r != NULL)
			*(r + 1) = '\0';

		/* use the data */
		if (strncasecmp(buf, "nameserver", 10) == 0)
		{
			in_addr_t addr;

			for (p = &buf[10]; *p != '\0'; p++)
			{
				if (isascii(*p) && isalnum(*p))
					break;
			}

			if (*p == '\0')
				continue;

			addr = inet_addr(p);
			if (addr == INADDR_NONE)
				continue;

			memcpy(&out->nsaddr_list[nscount].sin_addr.s_addr,
			       &addr,
			       sizeof out->nsaddr_list[nscount].sin_addr.s_addr);
			out->nsaddr_list[nscount].sin_family = AF_INET;
			out->nsaddr_list[nscount].sin_port = srv->s_port;

			nscount++;

			if (nscount == MAXNS)
				break;
		}
	}

	fclose(f);

	out->nscount = nscount;
	out->retrans = RES_TIMEOUT;
	out->retry = RES_RETRY;

	return 0;
}

#ifdef TEST
int
main()
{
	int c;
	struct __res_state test;

	ar_res_manual(&test);

	printf("_res.retrans = %d\n_res.retry = %d\n",
	       test.retrans, test.retry);
	for (c = 0; c < test.nscount; c++)
	{
		printf("nameserver %s\n",
		       inet_ntoa(test.nsaddr_list[c].sin_addr));
	}
}
#endif /* TEST */

#endif /* AR_RES_MANUAL */
