/*
**  Copyright (c) 2006-2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: dkim-config.h,v 1.6 2007/03/05 18:52:15 msk Exp $
*/

#ifndef _DKIM_CONFIG_H_
#define _DKIM_CONFIG_H_

#ifndef lint
static char dkim_config_h_id[] = "@(#)$Id: dkim-config.h,v 1.6 2007/03/05 18:52:15 msk Exp $";
#endif /* !lint */

struct configdef dkimf_config[] =
{
	{ "AutoRestart",		CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "Background",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "Canonicalization",		CONFIG_TYPE_STRING,	FALSE },
	{ "DNSTimeout",			CONFIG_TYPE_INTEGER,	FALSE },
	{ "Domain",			CONFIG_TYPE_STRING,	FALSE },
	{ "ExternalIgnoreList",		CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_FLUSH_HEADERS
	{ "FlushHeaders",		CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_FLUSH_HEADERS */
	{ "KeyFile",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_MULTIPLE_KEYS
	{ "KeyList",			CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_MULTIPLE_KEYS */
	{ "InternalHosts",		CONFIG_TYPE_STRING,	FALSE },
	{ "MacroList",			CONFIG_TYPE_STRING,	FALSE },
	{ "Minimum",			CONFIG_TYPE_STRING,	FALSE },
	{ "Mode",			CONFIG_TYPE_STRING,	FALSE },
	{ "MTA",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_OMIT_HEADERS
	{ "OmitHeaders",		CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_OMIT_HEADERS */
	{ "On-BadSignature",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-DNSError",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-InternalError",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-NoSignature",		CONFIG_TYPE_STRING,	FALSE },
	{ "On-SignatureMissing",	CONFIG_TYPE_STRING,	FALSE },
	{ "PeerList",			CONFIG_TYPE_STRING,	FALSE },
	{ "PidFile",			CONFIG_TYPE_STRING,	FALSE },
#ifdef POPAUTH
	{ "POPDBFile",			CONFIG_TYPE_STRING,	FALSE },
#endif /* POPAUTH */
#ifdef _FFR_QUARANTINE
	{ "Quarantine",			CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_QUARANTINE */
#ifdef _FFR_REQUIRED_HEADERS
	{ "RequiredHeaders",		CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_REQUIRED_HEADERS */
	{ "Selector",			CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_REPORTINFO
	{ "SendReports",		CONFIG_TYPE_BOOLEAN,	FALSE },
#endif /* _FFR_REPORTINFO */
	{ "SignatureAlgorithm",		CONFIG_TYPE_STRING,	FALSE },
#ifdef _FFR_SELECT_SIGN_HEADERS
	{ "SignHeaders",		CONFIG_TYPE_STRING,	FALSE },
#endif /* _FFR_SELECT_SIGN_HEADERS */
	{ "Socket",			CONFIG_TYPE_STRING,	FALSE },
	{ "SubDomains",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "Syslog",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ "UserID",			CONFIG_TYPE_STRING,	FALSE },
	{ "Version",			CONFIG_TYPE_STRING,	FALSE },
	{ "X-Header",			CONFIG_TYPE_BOOLEAN,	FALSE },
	{ NULL,				-1,			FALSE }
};

#endif /* _DKIM_CONFIG_H_ */
