/*
**  Copyright (c) 2005, 2006 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef _DKIM_TYPES_H_
#define _DKIM_TYPES_H_

#ifndef lint
static char dkim_types_h_id[] = "@(#)$Id: dkim-types.h,v 1.36 2006/09/15 05:08:28 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <regex.h>

/* libsm includes */
#include <sm/gen.h>
#include <sm/types.h>
#include <sm/cdefs.h>

/* libar includes */
#if USE_ARLIB
# include <ar.h>
#endif /* USE_ARLIB */

/* OpenSSL includes */
#include <openssl/pem.h>
#include <openssl/rsa.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/sha.h>

/* libdkim includes */
#include "dkim.h"

/* struct dkim_header -- an RFC2822 header of some kind */
struct dkim_header
{
	int			hdr_flags;
	u_char *		hdr_text;
	struct dkim_header *	hdr_next;
};

/* struct dkim_plist -- a parameter/value pair */
struct dkim_plist
{
	u_char *		plist_param;
	u_char *		plist_value;
	struct dkim_plist *	plist_next;
};

/* struct dkim_set -- a set of parameter/value pairs */
struct dkim_set
{
	bool			set_done;
	dkim_set_t		set_type;
	u_char *		set_data;
	struct dkim_plist *	set_plist;
	struct dkim_set *	set_next;
};

/* struct dkim_sha1 -- stuff needed to do a sha1 hash */
struct dkim_sha1
{
	int			sha1_tmpfd;
	BIO *			sha1_tmpbio;
	SHA_CTX			sha1_ctx;
	u_char			sha1_out[SHA_DIGEST_LENGTH];
};

#ifdef SHA256_DIGEST_LENGTH
/* struct dkim_sha256 -- stuff needed to do a sha256 hash */
struct dkim_sha256
{
	int			sha256_tmpfd;
	BIO *			sha256_tmpbio;
	SHA256_CTX		sha256_ctx;
	u_char			sha256_out[SHA256_DIGEST_LENGTH];
};
#endif /* SHA256_DIGEST_LENGTH */

/* struct dkim_rsa -- stuff needed to do RSA sign/verify */
struct dkim_rsa
{
	u_char			rsa_pad;
	size_t			rsa_keysize;
	size_t			rsa_rsainlen;
	size_t			rsa_rsaoutlen;
	EVP_PKEY *		rsa_pkey;
	RSA *			rsa_rsa;
	u_char *		rsa_rsain;
	u_char *		rsa_rsaout;
};

/* struct dkim -- a complete DKIM transaction context */
struct dkim
{
	u_char			dkim_lastchar;
	bool			dkim_writesep;
	bool			dkim_partial;
	bool			dkim_bodydone;
	bool			dkim_blankline;
	bool			dkim_subdomain;
#ifdef _FFR_ALLMAN_SSP_02
	bool			dkim_userpolicy;
#endif /* _FFR_ALLMAN_SSP_02 */
	int			dkim_signum;
	int			dkim_mode;
	int			dkim_state;
	int			dkim_timeout;
	int			dkim_hashtype;
	int			dkim_sigtype;
	int			dkim_shcnt;
#if _FFR_SET_DNS_CALLBACK
	u_int			dkim_callback_int;
#endif /* _FFR_SET_DNS_CALLBACK */
	u_int			dkim_blanks;
	u_int			dkim_keybits;
	u_int			dkim_version;
	size_t			dkim_b64keylen;
	size_t			dkim_b64siglen;
	size_t			dkim_keylen;
	size_t			dkim_siglen;
	time_t			dkim_timestamp;
	dkim_query_t		dkim_querymethod;
	dkim_canon_t		dkim_hdrcanonalg;
	dkim_canon_t		dkim_bodycanonalg;
	dkim_alg_t		dkim_signalg;
	off_t			dkim_bodylen;
	off_t			dkim_signlen;
	off_t			dkim_canonlen;
	const char *		dkim_id;
	u_char *		dkim_domain;
	u_char *		dkim_user;
	u_char *		dkim_selector;
	u_char *		dkim_hdrlist;
	u_char *		dkim_b64key;
	u_char *		dkim_b64sig;
	u_char *		dkim_shlist;
	u_char *		dkim_key;
	u_char *		dkim_sig;
	u_char *		dkim_reportaddr;
	u_char *		dkim_sender;
	u_char *		dkim_signer;
	u_char **		dkim_shset;
	char *			dkim_tmpdir;
	void *			dkim_hash;
	void *			dkim_bhash;
	void *			dkim_signature;
	void *			dkim_memclosure;
	void *			dkim_closure;
#if _FFR_SET_DNS_CALLBACK
	void *			dkim_user_context;
	void			(*dkim_dns_callback) (void *context);
#endif /* _FFR_SET_DNS_CALLBACK */
	struct dkim_set *	dkim_sethead;
	struct dkim_set *	dkim_settail;
	struct dkim_set *	dkim_sigset;
	struct dkim_header *	dkim_hhead;
	struct dkim_header *	dkim_htail;
	struct dkim_header *	dkim_senderhdr;
	DKIM_LIB *		dkim_libhandle;
};

/* struct dkim_lib -- a DKIM library context */
struct dkim_lib
{
	bool			dkiml_signre;
	u_int			dkiml_flags;
	u_int			dkiml_timeout;
	u_int			dkiml_version;
	void *			(*dkiml_malloc) (void *closure, size_t nbytes);
	void			(*dkiml_free) (void *closure, void *p);
	u_char			dkiml_tmpdir[MAXPATHLEN + 1];
#if USE_ARLIB
	AR_LIB			dkiml_arlib;
#endif /* USE_ARLIB */
	u_char **		dkiml_senderhdrs;
	regex_t			dkiml_hdrre;
};

#endif /* _DKIM_TYPES_H_ */
