/*
**  Copyright (c) 2005, 2006 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef lint
static char fix_c_id[] = "@(#)$Id: fix.c,v 1.5 2006/04/18 07:57:43 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#ifdef DARWIN
# include <arpa/nameser.h>
#endif /* DARWIN */
#include <resolv.h>
#include <netdb.h>

/* macros */
#ifndef _PATH_RESCONF
# define _PATH_RESCONF	"/etc/resolv.conf"
#endif /* ! _PATH_RESCONF */
#ifndef RES_RETRY
# define RES_RETRY	4
#endif /* ! RES_RETRY */
#ifndef RES_TIMEOUT
# define RES_TIMEOUT	5
#endif /* ! RES_TIMEOUT */

#define BUFRSZ		1024

#define	SERVICE		"domain"
#define	PROTOCOL	"udp"

/*
**  AR_RES_STRUCTURE -- res_init() replacement for systems that don't follow
**                 the de facto standards (e.g. OpenBSD 3.7)
**
**  Parameters:
**  	None.
**
**  Return value:
**  	0 on success, -1 on failure.
**
**  Notes:
**  	This only populates some of the _res structure, i.e. those fields
**  	required by this library.  It could easily be extended to do the
**  	whole thing though, and thus be generally useful.  Or you could just
**  	use the res_init() source code from the ISC or the single-threaded
**  	implementation of res_init() from your favourite operating system.
*/

int
ar_res_init(void)
{
#ifdef NONSTANDARD_RES_STRUCTURE
	int data;
	int nscount = 0;
	FILE *f;
	char *p;
	char *q;
	char *r;
	struct servent *srv;
	char buf[BUFRSZ];

	memset(&_res, '\0', sizeof _res);

	srv = getservbyname(SERVICE, PROTOCOL);
	if (srv == NULL)
		return -1;

	f = fopen(_PATH_RESCONF, "r");
	if (f == NULL)
		return -1;

	clearerr(f);
	while (fgets(buf, sizeof buf, f) != NULL)
	{
		/* chomp at \n, #, or ; */
		for (p = buf; *p != '\0'; p++)
		{
			if (*p == '\n' || *p == ';' || *p == '#')
			{
				*p = '\0';
				break;
			}
		}

		/* now eat leading and trailing spaces */
		data = 0;
		r = NULL;
		for (p = buf, q = buf; *p != '\0'; p++)
		{
			if (data == 0 && isascii(*p) && isspace(*p))
				continue;

			data = 1;
			*q = *p;
			if (!(isascii(*p) && isspace(*p)))
				r = q;
			q++;
		}
		if (r != NULL)
			*(r + 1) = '\0';

		/* use the data */
		if (strncasecmp(buf, "nameserver", 10) == 0)
		{
			in_addr_t addr;

			for (p = &buf[10]; *p != '\0'; p++)
			{
				if (isascii(*p) && isalnum(*p))
					break;
			}

			if (*p == '\0')
				continue;

			addr = inet_addr(p);
			if (addr == INADDR_NONE)
				continue;

			memcpy(&_res.nsaddr_list[nscount].sin_addr.s_addr,
			       &addr,
			       sizeof _res.nsaddr_list[nscount].sin_addr.s_addr);
			_res.nsaddr_list[nscount].sin_family = AF_INET;
			_res.nsaddr_list[nscount].sin_port = srv->s_port;

			nscount++;

			if (nscount == MAXNS)
				break;
		}
	}

	fclose(f);

	_res.nscount = nscount;
	_res.retrans = RES_TIMEOUT;
	_res.retry = RES_RETRY;

	return 0;
#else /* NONSTANDARD_RES_STRUCTURE */
	return res_init();
#endif /* NONSTANDARD_RES_STRUCTURE */
}

#ifdef TEST
int
main()
{
	int c;

	ar_res_init();

	printf("_res.retrans = %d\n_res.retry = %d\n",
	       _res.retrans, _res.retry);
	for (c = 0; c < _res.nscount; c++)
	{
		printf("nameserver %s\n",
		       inet_ntoa(_res.nsaddr_list[c].sin_addr));
	}
}
#endif /* TEST */
