#!/usr/bin/perl -w 
#
# Copyright (C) 2001-2002 J.I. van Hemert
#
# index.cgi - connect to freedb's http server and collect an entry,
# then transform it into jewel covers using Disc-Cover.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Author: J.I. van Hemert <jvhemert@cs.leidenuniv.nl>
#
# Physical mail:
# LIACS - Leiden University
# Niels Bohrweg 1
# 2333 CA Leiden
# The Netherlands
#
#
# $Id: index.cgi,v 1.1 2002/01/30 15:37:23 jano Exp $
#

use CGI qw/:standard :default_dtd/;
use strict;
#DEBUG#print "Content-Type: text/plain\n\n";
default_dtd('-//W3C//DTD HTML 4.01//EN');

if (param("results"))
{
	my $format = param("format");
	my $address = param("results");
	my $sideflap = param("sideflap");
	my $casetype = param("casetype") || "jewel";
	my $extendedtrackinfo = param("extendedtrackinfo") || "";

	my $result = `wget -O - -o /dev/null \"$address\"`;
	#open IN, "<result.html" or die $!; my $result; while (<IN>) { $result .= $_; } close IN;
	my ($freedb_address) = ($result =~ /(http:\/\/www\.freedb\.org\/freedb\/[a-z]+\/[0-9a-f]+)/mg);
	my $freedb_entry = `wget -O - -o /dev/null \"$freedb_address\"`;

	my $disc_cover = "./disc-cover -b \'$sideflap\' $extendedtrackinfo -c \'$casetype\' -f - -o -";

	if ($format eq "ps")
	{
		print header(-type=>'application/postscript');
		print `echo \"$freedb_entry\" | $disc_cover -t ps`;
	}
	elsif ($format eq "pdf")
	{
		print header(-type=>'application/pdf');
		print `echo \"$freedb_entry\" | $disc_cover -t pdf`;
	}
	elsif ($format eq "tex")
	{
		print header(-type=>'text/x-tex');
		print `echo \"$freedb_entry\" | $disc_cover -t tex`;
	}
	elsif ($format eq "dvi")
	{
		print header(-type=>'application/x-dvi');
		print `echo \"$freedb_entry\" | $disc_cover -t dvi`;
	}
	elsif ($format eq "html")
	{
		print header();
		print `echo \"$freedb_entry\" | $disc_cover -t html`;
	}
	elsif ($format eq "txt")
	{
		print header(-type=>'text/plain');
		print `echo \"$freedb_entry\" | $disc_cover -t txt`;
	}
	elsif ($format eq "cddb")
	{
		print header(-type=>'text/plain');
		print `echo \"$freedb_entry\" | $disc_cover -t cddb`;
	}
	elsif ($format eq "lbl")
	{
		print header(-type=>'text/plain');
		print `echo \"$freedb_entry\" | $disc_cover -t lbl`;
	}
	else
	{
		print
			header(),
			start_html(-title=>'Disc-Cover: FreeDB -> Jewel Cover', -meta=>{'copyright'=>'Copyright 2001-2002 by J.I. van Hemert', 'keywords' => 'jewel cddb cover disc-cover freedb cddbp postscript pdf tex html txt', description=>'Create jewel covers online', 'creator' => 'jvhemert@cs.leidenuniv.nl'}, -text=>'black', -bgcolor=>'white', -alink=>'red', -vlink=>'#AAAAAA', -link=>'#AAAAAA'
			#-meta=>{'HTTP-EQUIV' => "Pragma", 'CONTENT' => "no-cache"}
			),
			font({-color=>"red"}, "This format is not implemented"),
			end_html();
	}

	exit (0);
}





print
	header(),
	start_html(-title=>'Disc-Cover: FreeDB -> Jewel Cover', -meta=>{'copyright'=>'Copyright 2001-2002 by J.I. van Hemert', 'keywords' => 'jewel cddb cover disc-cover freedb cddbp postscript pdf tex html txt', description=>'Create jewel covers online', 'creator' => 'jvhemert@cs.leidenuniv.nl'}, -text=>'black', -bgcolor=>'white', -alink=>'red', -vlink=>'#333399', -link=>'blue'
	#-meta=>{'HTTP-EQUIV' => "Pragma", 'CONTENT' => "no-cache"}
	),"\n";

print	h1("Disc-Cover online"),
	"This page enables you to testdrive ",a({-href=>"http://www.liacs.nl/~jvhemert/disc-cover"}, "Disc-Cover")," before attempting installation on your own system. Just fill in an artist and/or title below. We will search the ",a({-href=>"http://www.freedb.org"}, "FreeDB")," database and show all the results. Then, select your desired cd and we will create a cover for a jewel case.",p(),"To make life even easier install Disc-Cover on your own system as it is able to detect which cd is in the drive automatically.",p();

print	start_form(-action=>"", -method=>"post"),
	b("artist / title:"),
	br,
	textfield(-name=>"q"),
	"&nbsp;",
	submit(),
	end_form(),
	p,hr;

if (param("q"))
{
	print h2("Create cover");
	my $query = param_fetch('q')->[0];
	
	$query =~ s/ /\+/g;
	my $result = `wget -O - -o /dev/null \'http://www.freedb.org/freedb_search.php?words=$query&allfields=NO&fields=artist&fields=title&allcats=YES&grouping=none\'`;
	#DEBUG# open IN, "<result" or die $!; my $result; while (<IN>) { $result .= $_; } close IN;
	if ($result =~ /<b>Warning<\/b>:  OCI/)
	{
		print "Something appears to be wrong with the ",a({-href=>"http://freedb.music.sk/search/index.phtml?search=$query"}, "FreeDB search engine"),", please check it out and notify the maintainers.";
	}
	else
	{
		my @entries = ($result =~ /<a href=\"(http:\/\/www.freedb.org\/freedb_search_fmt.php\?cat=[a-z]+\&id=[a-f0-9]+)\">([^<]+)<\/a>/mg);
		my $matches = @entries;
		my ($specific) = ($result =~ /lot of matches found/mg);
		#DEBUG# print STDERR "Matches found: $matches\n";
		if (defined $matches and $matches > 0)
		{
			#DEBUG# print $result;
			CGI::delete("q");
			print
				start_form(-action=>"", -method=>"post"),
				submit(-name=>"submit", -value=>"generate cover"),
				p;
				
			print "<table cellspacing=0 cellpadding=0 border=0><tr><td>".b("output format")."</td></tr><tr><td>";
			print radio_group(	-name=>'format',
						-values=>['ps','pdf','dvi','tex','txt','html','lbl','cddb'],
						-default=>'',
						#-linebreak=>'true',
						-rows=>1,
						-labels=>{ 	'ps' => 'PostScript',
								'pdf' => 'PDF',
								'tex' => 'LaTeX',
								'html' => 'HTML',
								'txt' => 'Plain text',
								'lbl' => 'CDlabelgen',
								'cddb' => 'CDDB'
							}
			);
			print "</td></tr></table>";

			print p;

			print "<table cellspacing=0 cellpadding=0 border=0><tr><td>".b("cover type")."</td></tr><tr><td>";
			print radio_group(	-name=>'casetype',
						-values=>['jewel','slim'],
						-default=>'',
						#-linebreak=>'true',
						-rows=>1,
						-labels=>{ 	'slim' => 'Slim',
								'jewel' => 'Jewel'
							}
			);
			print "</td></tr></table>";

			print p;

			print b("text on side flap (not necessary)"),br;
			print textfield(-name=>"sideflap");

			print p;

			print b("enable extended track info"),br;
			print checkbox(-name=>"extendedtrackinfo", -checked=>1, -value=>"-e", -label=>"");

			print p;

			my @values;
			my %labels;
			while (@entries)
			{
				my $address = shift @entries;
				my $name = shift @entries;
				
				push @values, $address;
				if ($name =~ /^[0-9]$/)
				{
					$name = " alternative option $name";
				}
				$labels{$address} = " $name";
			}

			print b("select cd (".($matches-1)." found)"),br;
			print radio_group(	-name=>'results',
						-values=>\@values,
						-default=>'',
						-linebreak=>'true',
						-labels=>\%labels
			);

			print
				end_form();
		}
		else
		{
			if (defined $specific)
			{
				print "Sorry, too many matches, be more specific";
			}
			else
			{
				print "Sorry, no matches found";
			}
		}
	}

	print p,hr;
}

print p."This system is powered by ";
print `./disc-cover -v | grep ^Disc-Cover`;

print p."Copyright &copy; 2001-2002 by ".a({-href=>"http://www.liacs.nl/~jvhemert"}, "J.I. van Hemert");
print end_html;
