/*
 * Some part are modified by kei@cs.uec.ac.jp and tomy@sfc.wide.ad.jp.
 */
/*
 * Copyright (c) 1983, 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(__bsdi__) || (__FreeBSD__ >= 2)

/* It's BSD/OS or FreeBSD 2.x */

/*
 * Modified by tomy@sfc.wide.ad.jp
 */
/*
 *
 * Copyright (c) 1983, 1989, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)route.c	8.3 (Berkeley) 3/19/94";
#endif /* not lint */

#include <unistd.h> 
#include <stdlib.h> 
#include <syslog.h>
#include <errno.h>
#include <string.h>
#include <sys/param.h> 
#include <sys/socket.h>
#include <sys/sysctl.h>
#include <sys/ioctl.h>
#include <net/route.h>
#include <net/if.h>
#include <net/if_dl.h>
#include <netinet/in.h>

int
ifindex(char *ifname)
{
  int s;
  caddr_t buf;
  struct ifconf ifc;
  struct sockaddr_dl *sdl;
  struct ifreq *ifr;
  int n, len;
  int size = 1024;

  if ((s = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
    syslog(LOG_ERR, "socket: %m");
    return(-1);
  }
  for (n = 0; n < 10; n++) {
    if ((buf = (caddr_t) malloc(size)) == NULL) {
      syslog(LOG_ERR, "no more memory");
      close(s);
      return(-1);
    }
    ifc.ifc_len = size;
    ifc.ifc_buf = buf;
    if (ioctl(s, SIOCGIFCONF, (char *)&ifc) >= 0)
      break;
    if (errno != EINVAL) {
      syslog(LOG_ERR, "SIOCGIFCONF: %m");
      close(s);
      return(-1);
    }
    free(buf);
    buf = NULL;
    size *= 2;
  }
  if (buf == NULL) {
    syslog(LOG_ERR, "SIOCGIFCONF: %m");
    close(s);
    return(-1);
  }
  for (n = 0, sdl = NULL; n < ifc.ifc_len; ) {
    ifr = (struct ifreq *) (ifc.ifc_buf + n);
    len = sizeof(ifr->ifr_name) + ifr->ifr_addr.sa_len;
    if (len < sizeof(struct ifreq))
      len = sizeof(struct ifreq);
    n += len;
    if (ifr->ifr_addr.sa_family != AF_LINK)
      continue;
    if (strcmp(ifr->ifr_name, ifname) == 0) {
      sdl = (struct sockaddr_dl *)&ifr->ifr_addr;
      break;
    }
  }
  if (sdl == NULL) {
    syslog(LOG_ERR, "%s: I/F not found", ifname);
    close(s);
    return(-1);
  }
  n = sdl->sdl_index;
#ifdef DEBUG
  syslog(LOG_ERR, "index for %s is %d", ifname, n);
#endif
  free(buf);
  close(s);

  return(n);
}


/*
 * Purge all entries in the routing tables not
 * associated with network interfaces.
 */

int
flushroutes(ifname)
  char *ifname;
{
  int s;
  size_t needed;
  int mib[6], rlen, seqno;
  char *buf, *next, *lim;
  register struct rt_msghdr *rtm;
  int idx;
  struct sockaddr_in *sin;

  if ((idx = ifindex(ifname)) < 0)    
    return(-1);

  if ((s = socket(PF_ROUTE, SOCK_RAW, 0)) < 0) { 
    syslog(LOG_WARNING, "socket() error in flushroutes(): %m");
    return(-1);
  }

  shutdown(s, 0);
  mib[0] = CTL_NET;
  mib[1] = PF_ROUTE;
  mib[2] = 0;             /* protocol */
  mib[3] = AF_INET;       /* only AF_INET considered */
  mib[4] = NET_RT_DUMP;
  mib[5] = 0;             /* no flags */

  if (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0) {
    syslog(LOG_WARNING, "sysctl() error in flushroutes(): %m");
    close(s);
    return(-1);
  }
  if ((buf = calloc(1, needed)) == NULL) {
    syslog(LOG_WARNING, "calloc() error in flushroutes(): %m");
    close(s);
    return(-1);
  }
  if (sysctl(mib, 6, buf, &needed, NULL, 0) < 0) {
    syslog(LOG_WARNING, "sysctl() error in flushroutes(): %m");
    free(buf);
    close(s);
    return(-1);
  }
  lim = buf + needed;
  seqno = 0;

  for (next = buf; next < lim; next += rtm->rtm_msglen) {
    rtm = (struct rt_msghdr *) next;
    sin = (struct sockaddr_in *)(rtm + 1);

    if (sin->sin_family != AF_INET)
      continue;
#ifdef DEBUG
    syslog(LOG_ERR, "rtaddr: %s index %d", inet_ntoa(sin->sin_addr),
	   rtm->rtm_index);
#endif
    if (rtm->rtm_index != idx)
      continue;

    rtm->rtm_type = RTM_DELETE;
    rtm->rtm_seq = seqno;
    rlen = write(s, next, rtm->rtm_msglen);
    if (rlen < (int)rtm->rtm_msglen) {
      break;
    }
    seqno++;
  }

  free(buf);
  close(s);
  return(0);
}

#else /* __bsdi__ or FreeBSD 2.x */

#include <stdio.h>
#include <nlist.h>
#include <syslog.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/mbuf.h>
#include <sys/ioctl.h>
#include <net/route.h>
#include <netinet/in.h>
#include <rpc/types.h>

#ifdef __osf__
#define rtentry ortentry
#endif

/*
 * from Berkeley's code (route.c 5.6 (Berkeley) 6/5/86)
 */
static struct nlist nl[] = {
#define N_RTHOST        0
        { "_rthost" },
#define N_RTNET         1
        { "_rtnet" },
#define N_RTHASHSIZE    2
        { "_rthashsize" },
        { "" }
};

int
flushroutes(dummy)
  char *dummy;
{
  static int first = 1;
  int s = 0;
  struct mbuf mb;
  register struct rtentry *rt = NULL;
  register struct mbuf *m = NULL;
  struct mbuf **routehash = NULL;
  int rthashsize = 0, i = 0, doinghost = 1, kmem = 0;

  bzero(&mb, sizeof(mb));

  if ((s = socket(AF_INET, SOCK_RAW, 0)) < 0) {
    return(-1);
  }

  if (first) {
    first = 0;
    nlist("/vmunix", nl);
  }
  if (nl[N_RTHOST].n_value == 0) {
    syslog(LOG_LOCAL0|LOG_ERR, "\"rthost\", symbol not in namelist");
    exit(1);
  }
  if (nl[N_RTNET].n_value == 0) {
    syslog(LOG_LOCAL0|LOG_ERR, "\"rtnet\", symbol not in namelist");
    exit(1);
  }
  if (nl[N_RTHASHSIZE].n_value == 0) {
    syslog(LOG_LOCAL0|LOG_ERR,
	   "\"rthashsize\", symbol not in namelist");
    exit(1);
  }
  kmem = open("/dev/kmem", 0);
  if (kmem < 0) {
    syslog(LOG_LOCAL0|LOG_ERR, "/dev/kmem: %m");
    exit(1);
  }
  lseek(kmem, nl[N_RTHASHSIZE].n_value, 0);
  read(kmem, &rthashsize, sizeof (rthashsize));
  routehash = (struct mbuf **)calloc(1, rthashsize*sizeof (struct mbuf *));

  lseek(kmem, nl[N_RTHOST].n_value, 0);
  read(kmem, routehash, rthashsize*sizeof (struct mbuf *));
again:
  for (i = 0; i < rthashsize; i++) {
    if (routehash[i] == 0)
      continue;
    m = routehash[i];
    while (m) {
      lseek(kmem, m, 0);
      read(kmem, &mb, sizeof (mb));
      rt = mtod(&mb, struct rtentry *);
      if (((struct sockaddr_in *)&rt->rt_dst)->sin_addr.s_addr
	  != INADDR_LOOPBACK) {
	ioctl(s, SIOCDELRT, (caddr_t)rt);
      }
      m = mb.m_next;
    }
  }
  if (doinghost) {
    lseek(kmem, nl[N_RTNET].n_value, 0);
    read(kmem, routehash, rthashsize*sizeof (struct mbuf *));
    doinghost = 0;
    goto again;
  }
  close(kmem);
  close(s);
  free(routehash);
  return(0);
}

#endif /* __bsdi__ or FreeBSD 2.x */
