#include "msg.h"

#include <errno.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>


bool err(const char *msg, bool sys, const char *id)
	{
	int lasterr = errno;

	WRITE_STR(2, "deco: ");
	WRITE_STR(2, msg);
	if (sys)
		{
		WRITE_STR(2, " (");
		WRITE_STR(2, strerror(lasterr));
		WRITE_STR(2, ")");
		}
	if (id)
		{
		WRITE_STR(2, ": ");
		WRITE_STR(2, id);
		}
	WRITE_STR(2, "\n");
	return false;  /* enables writing: return okay() || err(...) */
	}

void die(const char *msg, bool sys, const char *id)
	{
	err(msg, sys, id);
	exit(EXIT_FAILURE);
	}
