#include <dirent.h>
#include <stdbool.h>
#include <sys/types.h>


#ifndef FS
#define FS
enum type { Unknown, None, Dir, Other };
#endif


char *ent_from_path(const char *path);
enum type file_type(bool follow, const char *path);
bool is_dot(const char *ent);
DIR *open_dir(const char *path);
void pretty_print(const char *path, enum type typ);
bool rm_rf(const char *path);
int safe_rename(const char *src, enum type typ, const char *dst);
