#include "msg.h"

#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>


extern char **environ;


bool set_env(const char *var)
	{
	return putenv((char *)var) == 0 || err(MSG_PUTENV, true, var);
	}

void unset_env(const char *var)
	{
	size_t lvar;
	char **e;
	bool skip = 0;

	lvar = strlen(var);
	for (e = environ; *e; ++e)
		{
		skip = skip || (strncmp(*e, var, lvar) == 0 && (*e)[lvar] == '=');
		*e = *(e + skip);
		}
	}

bool spawn(void (*run)(void *), void *args, const char *msg, const char *id)
	{
	int status;

	switch (fork())
		{
		case -1: die(MSG_FORK, true, NULL);
		case  0: run(args);
		}
	wait(&status);
	return WEXITSTATUS(status) == 0 || err(msg, false, id);
	}

void exec(void *args)
	{
	char **cmd = args;

	if (dup2(2, 1) != 1)
		die(MSG_STDIN_TO_STDERR, true, NULL);
	execvp(cmd[0], cmd);
	die(MSG_EXEC, true, cmd[0]);
	}
