/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hublist.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include <string.h>

#if 1
#define HOSTNAME "www.neo-modus.com"
#define HOSTPORT 80
#define QUERY  "GET /PublicHubList.config HTTP/1.1\n"												\
					"Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n"		\
					"Host: www.neo-modus.com\n"															\
					"Cache-Control: no-cache\n"															\
					"Connection: close\n"																	\
					"\n"
#else
#define HOSTNAME "ac2i.tzo.com"
#define HOSTPORT 80
#define QUERY  "GET / HTTP/1.1\nHost: ac2i.tzo.com\nConnection: close\n\n"
#endif

#define TAILLE 4096

int main(int argc,char **argv)
{
	struct sockaddr_in nom;	/* adresse de la socket destinataire */
	int desc;		/* descripteur de la socket cree */
	struct hostent *hp;

	char com[TAILLE];
	FILE *output;
	int i;
	long nb;

	output=stdout;

	/* cration de la socket */
	if((desc=socket(AF_INET,SOCK_STREAM,0))==-1)
	{
		perror("unable to create socket");
		exit(1);
	}

	/* recherche de l'adresse internet du serveur */
	if((hp=gethostbyname(HOSTNAME))==NULL)
	{
		fprintf(stderr,"Unable to find host address.\n");
		exit(1);
	}

	/* demande de connexion */
	for(i=0;i<3;i++)
	{
		/* prparation de l'adresse de la socket destinataire */
		memcpy(&nom.sin_addr,hp->h_addr,hp->h_length);
		nom.sin_family=AF_INET;
		nom.sin_port=htons(HOSTPORT);

		if(connect(desc,(void*)&nom,sizeof(nom))!=-1)
		{
			int eoh;
			int have;
			/* send the query */
			send(desc,QUERY,strlen(QUERY),0);

			/* reception du bloc reponse */
			
			/* skip html header */
			eoh=0;
			have=0;
			do
			{
				if((recv(desc,com,1,MSG_WAITALL))<=0)
					exit(0);

				if(com[0]=='\n')
				{
					if(have==0)
						have=1;
					else
						eoh=1;		/* 2 consecutives \n */
				}
				else if(com[0]!='\r')
					have=0;

#if 0
				printf("=%c",com[0]);
#endif
			} while(eoh==0);

			/* display body content */
			do
			{
				nb=recv(desc,com,TAILLE,0);
				if(nb>0)
				{
					fwrite(com,nb,1,output);
				}
				fflush(stderr);
			}while(nb>0);

			exit(0);
		}
	}
	perror("connect");
	exit(0);
}

