#ifndef __DCTC_PROCESS_H__
#define __DCTC_PROCESS_H__

#include <gdk/gdk.h>

/******************************************************************************/
/* count the number of entry inside the given gchar * array (NULL terminated) */
/******************************************************************************/
int gchar_array_len(gchar **array);

/*************************************************************/
/* close the connection to the current DCTC client if exists */
/*************************************************************/
void close_current_dctc(void);

/***************************************************/
/* delete the array containing the nick of all ops */
/***************************************************/
void clear_op_array(void);

/**********************************************************************************/
/* this function is called when something comes from DCTC client                  */
/* data is always NULL, source == current_dctc_fd and condition == GTK_INPUT_READ */
/**********************************************************************************/
void process_data_from_dctc(gpointer data, gint source, GdkInputCondition condition);

/************************************************************************************/
/* same function as previous one except it tries to send queued data to DCTC client */
/************************************************************************************/
void process_data_to_dctc(gpointer data, gint source, GdkInputCondition condition);

/****************************************/
/* send data to the current DCTC client */
/* the function handles all errors      */
/****************************************/
void send_data_to_dctc(char *str);

/************************************************/
/* open password dialog to enter a new password */
/************************************************/
void enter_passwd_fnc(const GString *in);

/*****************************/
/* kill selected GDL entries */
/*****************************/
void kill_selected_gdl_entry(void);
void detach_selected_gdl_entry(void);	/* or detach it */

/*****************************************************************/
/* create autoscan configuration window for selected GDL entries */
/*****************************************************************/
void create_autoscan_window_for_selected_gdl_entry(void);

/**********************************************************************/
/* kill upload or download task using their ID (and /KILL or /KILLKB) */
/**********************************************************************/
void kill_selected_entry(char *cmd,char *clist_name);

/************************************/
/* view file list of selected users */
/************************************/
void view_file_selected_entry(char *cmd,char *clist_name);

/*******************************************************************/
/* return the GTK_TEXT widget of the chat having the LABEL == nick */
/* if nick doesn't have a private chat, the function creates one.  */
/*******************************************************************/
GtkWidget *get_pchat_text_widget_from_nick(char *nick);

/***********************************************************************************/
/* when the multihub search is enabled, this function is called after 10 seconds   */
/* if more than 15 results are available, nothing occurs, else a /MSRCH is started */
/***********************************************************************************/
gint start_msearch(gpointer data);

#endif
