/* darkstat 3
 * copyright (c) 2001-2007 Emil Mikulic.
 *
 * cap.h: interface to libpcap.
 */

#include <sys/types.h> /* OpenBSD needs this before select */
#include <sys/time.h> /* FreeBSD 4 needs this for struct timeval */
#include <sys/select.h>

void cap_init(const char *device, const char *filter, int promisc);
void cap_fd_set(fd_set *read_set, int *max_fd,
   struct timeval *timeout, int *need_timeout);
void cap_poll(fd_set *read_set);
void cap_stop(void);

/* vim:set ts=3 sw=3 tw=78 expandtab: */
