#!/usr/bin/env perl

# Some tests for the output of changes when combined with move.

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

init_tmp_repo();

`date > foo`; # create foo!

like(darcs(q(add foo)), qr/^$/,
     "darcs add reports nothing");

like(darcs(q( record -m 'add foo' -a)), qr/Finished recording patch 'add foo'/,
     "darcs record reports 'Finished recording patch 'add foo''");

mkpath 'd';

like(darcs('add d'), qr/^$/,
     "darcs add reports nothing");

like(darcs(q( record -m 'add d' -a)), qr/Finished recording patch 'add d'/,
     "darcs record reports 'Finished recording patch 'add d''");

like(darcs(q( mv foo d)), qr/^$/,
     "darcs mv reports nothing");

like(darcs(q( record -m 'mv foo to d' -a)),
     qr/Finished recording patch 'mv foo to d'/,
     "darcs record reports 'Finished recording patch 'mv foo to d''");

like(darcs(q( mv d directory)), qr/^$/,
     "darcs mv reports nothing");

like(darcs(q( record -m 'mv d to directory' -a)),
     qr/Finished recording patch 'mv d to directory'/,
     "darcs record reports 'Finished recording patch 'mv d to directory''");

use File::Slurp;
write_file('directory/foo', 'How beauteous mankind is');

like(darcs(q( record -m 'modify directory/foo' -a)),
     qr/Finished recording patch 'modify directory\/foo'/,
     "darcs record reports 'Finished recording patch 'modify directory/foo''");

my $changes_output = darcs(q( changes directory/foo));
like($changes_output, qr/add foo/,
     "darcs changes reports 'add foo'");
like($changes_output, qr/mv foo to d/,
     "darcs changes reports 'mv foo to d'");

write_file('directory/foo', 'O brave new world');

like(darcs(q( mv directory/foo directory/bar)), qr/^$/,
     "darcs mv reports nothing");

write_file('directory/foo','echo That has such people in it');

like(darcs(q( add directory/foo)), qr/^$/,
     "darcs add reports nothing");

like(darcs(q( record -m 'mv foo then add new foo' -a)),
     qr/Finished recording patch 'mv foo then add new foo'/,
     "darcs record reports 'Finished recording patch 'mv foo then add new foo''");

my $annotate_output = darcs(q( annotate directory/bar));
like($annotate_output, qr/How beauteous mankind is/,
     "darcs annotate reports 'How beauteous mankind is'");
like($annotate_output, qr/O brave new world/,
     "darcs annotate reports 'O brave new world'");
