#!/usr/bin/env bash
set -ev

# This checks for a possible bug in patch selection where the no available
# patches case is hit.

if uname | grep -i cygwin ; then
    echo TODO: This test causes a setCooked: failed buffering error in
    echo Cygwin, but it works fine under MSYS, so we are ignoring it.
    exit 0
fi

rm -rf temp1
mkdir temp1
cd temp1
darcs init
touch A
darcs add A
darcs record -am A
echo 'l1' >> A
darcs record -am l1
darcs amend-record -a --patch 'A'

cd ..
rm -rf temp1
