#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf temp
mkdir temp
cd temp

$DARCS init
touch fee fi fo fum
$DARCS add f*
$DARCS record --author me --all --no-test --patch-name add
mkdir d
$DARCS add d
$DARCS mv f* d
$DARCS remove d/fi
cd d
$DARCS remove fo
echo let us have fun > fun
$DARCS add fun
$DARCS mv fun fum ..
$DARCS record --author me --all --no-test --patch-name mv
cd ..

test ! -f _darcs/pristine/fee
test ! -f fee
cmp d/fee _darcs/pristine/d/fee

test ! -f fi
test -f d/fi
test ! -f _darcs/pristine/fi
test ! -f _darcs/pristine/d/fi

test ! -f fo
test -f d/fo
test ! -f _darcs/pristine/fo
test ! -f _darcs/pristine/d/fo

cmp fun _darcs/pristine/fun
cmp fum _darcs/pristine/fum

$DARCS mv fun d
$DARCS record -A me -a --no-test -m "fun again"
cmp d/fun _darcs/pristine/d/fun
test ! -f fun
test ! -f _darcs/pristine/fun

# Now clean up.
cd ..
rm -rf temp

