/*
 Copyright (C) 2005 Juliusz Chroboczek

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 Boston, MA 02110-1301, USA.
*/



#include "cache.h"

struct git_file {
    unsigned char *data;
    char *type;
    unsigned long length;
};

struct git_file_info {
    unsigned int mode;
    char *name;
    unsigned char sha1[20];
};

struct git_tree_iterator {
    unsigned char *data;
    unsigned long length;
    unsigned long offset;
};

struct git_tree_element {
    char *name;
    unsigned mode;
    char sha1[20];
};

struct git_write_iterator {
    int count;
    int size;
    struct git_tree_element *elts;
};

struct git_file *git_read_file(const unsigned char *sha1);
void git_file_done(struct git_file *f);
unsigned char *git_head(char *);
int git_update_head(char*, char *);

void git_file_info_done(struct git_file_info *info);
unsigned int git_default_file_mode(unsigned int treep);
int git_is_tree(unsigned int mode);

struct git_tree_iterator *
git_tree_begin(unsigned char *data, unsigned long length);
struct git_file_info *git_tree_next(struct git_tree_iterator *iter);
void git_tree_done(struct git_tree_iterator *iter);
char *git_parse_time(unsigned long sec);
unsigned long git_format_time(char *string);

unsigned char *git_cache_entry_sha1(struct cache_entry *entry);
unsigned int git_cache_entry_size(struct cache_entry *entry);
unsigned int git_cache_entry_mtime(struct cache_entry *entry);
struct cache_entry *git_cache_entry(char *name);

int git_validate(char *string, char *sha_b, int n);

struct git_file_info *
git_write_file(char *type, char *name, unsigned mode,
               char *contents, unsigned int length);
struct git_write_iterator *git_write_tree_begin(void);
int git_write_tree_next(struct git_write_iterator *iter,
                        char *name, unsigned mode, char *sha1_s);
struct git_file_info *git_write_tree_done(struct git_write_iterator *iter,
                                          char *name, unsigned mode);
