#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs
export DARCS_EDITOR=echo

rm -rf temp1 temp2
mkdir temp1 temp2

cd temp2
$DARCS init

# setup test
cd ../temp1
$DARCS init
touch foo bar
$DARCS add foo bar
$DARCS record -a -m add_foo_bar -A x

# Test that a default preference value is not needed to send
$DARCS send --author=me -a --to=random@random "--sendmail-command=cat %<" ../temp2 | grep -x "To: random@random" 

# Test that a default preference will be used when no --to value is specified
echo "default@email" > ../temp2/_darcs/prefs/email 
$DARCS send --author=me -a "--sendmail-command=cat %<" ../temp2 | grep -x "To: default@email"

# Test that the --to parameter overrides the default value in the repository
$DARCS send --author=me -a --to=override@default "--sendmail-command=cat %<" ../temp2 | grep -x "To: override@default"

rm -rf temp1 temp2
