-- Copyright (C) 2005 David Roundy
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software Foundation,
-- Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

module FilePathUtils ( fix_maybe_absolute, unfix_maybe_absolute,
                       drop_paths, (///) ) where

import Maybe ( catMaybes )

import Autoconf ( path_separator )
import FileName ( fn2fp, fp2fn, norm_path )
import DarcsURL ( is_relative, is_file )
#include "impossible.h"

fix_maybe_absolute :: FilePath -> FilePath -> FilePath
fix_maybe_absolute _ pat | not $ is_file pat = pat
fix_maybe_absolute fix pat = fma $ map cleanup pat
    where fma p@('/':_) = p
          fma p = fix /// p
          cleanup '\\' | path_separator == '\\' = '/'
          cleanup c = c

unfix_maybe_absolute :: FilePath -> FilePath -> FilePath
unfix_maybe_absolute _ pat | not $ is_file pat = pat
unfix_maybe_absolute fix pat = fma $ map cleanup pat
    where fma p@('/':_) = p
          fma p = make_dotdots fix /// p
          cleanup '\\' | path_separator == '\\' = '/'
          cleanup c = c

make_dotdots :: FilePath -> FilePath
make_dotdots "" = ""
make_dotdots p@('/':_) = bug $ "Can't make_dotdots on an absolute path:  "
                         ++ p
make_dotdots p = "../" ++ case snd $ break (=='/') p of
                          "" -> ""
                          r -> make_dotdots r

drop_paths :: String -> [String] -> [String]
drop_paths "" ps = map norm_relative ps
    where norm_relative f | is_relative f = do_norm f
                          | otherwise = f
drop_paths fix ps = catMaybes $ map drop_path ps
  where drop_path p | not $ is_relative p = Just p
        drop_path ('.':'/':p) = drop_path $ dropWhile (=='/') p
        drop_path p = if take (length fix) p == fix
                      then Just $ dropWhile (=='/') $ drop (length fix) p
                      else if is_relative p
                           then Nothing
                           else Just p

(///) :: FilePath -> FilePath -> FilePath
""///a = do_norm a
a///b = do_norm $ a ++ "/" ++ b

do_norm :: FilePath -> FilePath
do_norm f = fn2fp $ norm_path $ fp2fn f
