-- Copyright (C) 2003 David Roundy
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software Foundation,
-- Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

module Main (main) where

import DarcsCommands
import TheCommands
import Time

main = man the_commands

man :: [DarcsCommand] -> IO ()
man cs = do man_header
            man_helper cs
            man_trailer

man_helper :: [DarcsCommand] -> IO ()
man_helper [] = return ()
man_helper (c:cs) = do
  putStr $ ".TP\n.B "++command_name c++"\n"
  putStr $ command_help c++"\n"
  man_helper cs

pad_spaces :: String -> Int -> String
pad_spaces s n
    | length s < n = pad_spaces (s++" ") n
    | otherwise = s

man_trailer :: IO ()
man_trailer = putStr "
.SH AUTHOR
David Roundy <droundy@abridgegame.org>.
"

man_header :: IO ()
man_header = do
  putStr ".TH DARCS \"1\" \""
  cl <- getClockTime
  ct <- toCalendarTime cl
  putStr $ show (ctMonth ct) ++ " " ++ show (ctYear ct)
  putStr "\" \"darcs\" \"User Commands\"\n"
  putStr ".SH NAME
darcs \\- David's Advanced Revision Control System
.SH SYNOPSIS
.B darcs
\\fICOMMAND \\fR...
.SH DESCRIPTION

darcs is a nifty revision control tool.  For more a detailed description,
see the html documentation, which should be available at
/usr/share/doc/darcs/manual/index.html.  To easily get more specific help
on each command, you can call `darcs COMMAND --help'

.SH COMMANDS
"

