#ifndef __H_PLATFORM
#define __H_PLATFORM 1

#ifdef HAVE_CONFIG_H
	#include "dgconfig.h"
#endif

#define __CONFFILE "/usr/local/etc/dansguardian/dansguardian.conf"
#define __PIDDIR "/usr/local/var/run/"
#define __LOGLOCATION "/usr/local/var/log/dansguardian/"
#define __PROXYUSER "nobody"
#define __PROXYGROUP "nobody"
#define __CONFDIR "/usr/local/etc/dansguardian"

#if defined(__GNUG__) && __GNUG__ >= 3
	#define __GCCVER3 1
#endif

#ifdef HAVE_SYS_WAIT_H
	#include <sys/wait.h>
#else
	#ifdef HAVE_WAIT_H
		#include <wait.h>
	#else
		#error "You have no sys/wait.h and no wait.h"
	#endif
#endif

#ifdef HAVE_SYS_SELECT_H
	#include <sys/select.h>
#else
	#error "You have no sys/select.h"
#endif

#ifdef HAVE_DARWIN
	#ifndef _BSD_SOCKLEN_T_
		#define _BSD_SOCKLEN_T_ size_t
	#endif
	#define __DARWIN 1
#endif

#ifdef HAVE_BSD
	#define __BSD 1
#endif

#ifdef HAVE_DGDEBUG
	#define DGDEBUG 1
#endif

#ifdef ENABLE_FANCYDM
	#define __FANCYDM
#endif

#ifdef ENABLE_TRICKLEDM
	#define __TRICKLEDM
#endif

#ifdef HAVE_PCRE
	#define __PCRE
#endif

#ifdef HAVE_KAVCLIENT
	#define __KAVAV
#endif

#ifdef HAVE_CLAMAV
	#define __CLAMAV
#endif

#ifdef HAVE_CLAMAV_SHM
	#define __CLAMAV_SHM
#endif

#ifdef ENABLE_CLAMD
	#define __CLAMD
#endif

#ifdef ENABLE_ICAP
	#define __ICAP
#endif

#ifdef ENABLE_KAVD
	#define __KAVD
#endif

#ifdef ENABLE_NTLM
	#define __NTLM
#endif

#ifdef ENABLE_COMMANDLINE
	#define __COMMANDLINE
#endif

#ifdef ENABLE_EMAIL
	#define __EMAIL
#endif

#ifdef ENABLE_SEGV_BACKTRACE
	#define __SEGV_BACKTRACE
#endif

#endif //ifndef __H_PLATFORM
