#!/bin/sh

P=./cvs2cl.pl

# Only get the log data once, that's more efficient:
cvs log > tlog$$.out

echo ""

# Basic format
echo "Generating ChangeLog-basic.txt..."
${P} --fsf --header /dev/null -f ChangeLog-basic.txt --stdin < tlog$$.out

# With XML output
echo "Generating ChangeLog-xml.txt..."
${P} --xml --fsf -f ChangeLog-xml.txt --stdin < tlog$$.out

# With revisions
echo "Generating ChangeLog-revs.txt..."
${P} -r --fsf --header /dev/null -f ChangeLog-revs.txt --stdin < tlog$$.out

# With tags
echo "Generating ChangeLog-tags.txt..."
${P} -t --fsf --header /dev/null -f ChangeLog-tags.txt --stdin < tlog$$.out

# With branches
echo "Generating ChangeLog-branches.txt..."
${P} -b --fsf --header /dev/null -f ChangeLog-branches.txt --stdin < tlog$$.out

# With tags and revisions
echo "Generating ChangeLog-tags-revs.txt..."
${P} -t -r --fsf --header /dev/null -f ChangeLog-tags-revs.txt \
     --stdin < tlog$$.out

# With branches and revisions
echo "Generating ChangeLog-branches-revs.txt..."
${P} -b -r --fsf --header /dev/null -f ChangeLog-branches-revs.txt \
     --stdin < tlog$$.out

# With tags and branches
echo "Generating ChangeLog-tags-branches.txt..."
${P} -t -b --fsf --header /dev/null -f ChangeLog-tags-branches.txt \
     --stdin < tlog$$.out

# With tags, branches, and revisions
echo "Generating ChangeLog-tags-branches-revs.txt..."
${P} -b -r -t --fsf --header /dev/null -f ChangeLog-tags-branches-revs.txt \
     --stdin < tlog$$.out

# With tags, branches, and revisions
echo "Generating ChangeLog-the-works.txt..."
${P} -b -r -t --fsf -U /usr/local/cvs/CVSROOT/users --day-of-week --header \
     /dev/null -f ChangeLog-the-works.txt --stdin < tlog$$.out

echo ""
echo "Done."

rm tlog$$.out
