module Main(main) where

import IO
import Char
import Control.Monad.State
import Codec.ASN1.ASN1
import Codec.Encryption.Utils
import Codec.Encryption.PKCS8

{-
Generate a key pair.

> openssl genrsa -out private.pem

And convert the private key to PKCS8 format without encryption.

> openssl pkcs8 -topk8 -inform PEM -outform DER -in private.pem -nocrypt -out private.der

Now read it with the Haskell program.
-}

main = 
   do ifh <- openFile "private.der" ReadMode
      (x,y) <- decode ifh
      let z::PrivateKeyInfo
          z = fromASN NoTag y 
      putStrLn $ show z
      -- Decoding can be done using a state monad as an alternative.
      -- stdin is a dummy file handle so that the overloaded function decode can be used.
      let test = 
             runState (decode stdin) (map (chr . fromIntegral) 
                                          (encode (toASN NoTag z)))
          test' :: PrivateKeyInfo
          test' = let ((x,y),z) = test in fromASN NoTag y
      putStrLn $ show test'
