/* common.statistics.n-grams.h - common monoalphabetic key manipulation routines header file
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "common.monoalphabetic.h"

typedef struct {
    float *slft;
    float *bift;
    float *trift;
    float slft_error;
    float bift_error;
    float trift_error;
    float total_error;
    int letter_count;
    float ic; /* Index of coincidence */
    float entropy;
    float efficiency;
    float redundancy;
} stats;

#define DEFAULT_SLFT "data/slft.dat"
#define DEFAULT_BIFT "data/bift.dat"
#define DEFAULT_TRIFT "data/trift.dat"

#define STR_FREQUENCY "Frequency"
#define STR_STANDARD_FREQUENCY "Standard Frequency"

#define FT_SLFT  1
#define FT_BIFT  2
#define FT_TRIFT 3

extern const float error_weight[];

int randnum (int a, int b);
float total_error(float slft_error, float bift_error, float trift_error);
float slft_error(float *slft_std, float *slft_sample);
float bift_error(float *bift_std, float *bift_sample);
float trift_error(float *trift_std, float *trift_sample);
int make_ft(char *text, float *slft, float *bift, float *trift);
void dup_ft(stats *s, float *slft, float *bift, float *trift);
float calc_ic(float *slft, int letter_count);
float calc_entropy(float *slft);
float calc_redundancy(float efficiency);
stats *transform_stats_with_key(stats *s, key *key, float *slft_std, float *bift_std, float *trift_std);
stats *make_stats(char *text, float *slft_std, float *bift_std, float *trift_std);
void free_stats(stats *the_stats);
stats *dup_stats(stats *the_stats);
float *load_slft_std(char *filename);
float *load_bift_std(char *filename);
float *load_trift_std(char *filename);
void do_save_slft(float *slft);
void do_save_bift(float *bift);
void do_save_trift(float *trift);
