#ifndef	imapscanclient_h
#define	imapscanclient_h

/*
** Copyright 1998 - 2003 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char imapscanclient_h_rcsid[]="$Id: imapscanclient.h,v 1.6 2003/01/23 13:02:39 mrsam Exp $";
/*
** Stuff we want to know about an individual message in the maildir.
*/

struct imapscanmessageinfo {
	unsigned long uid;	/* See RFC 2060 */
	char *filename;
	char recentflag;
	char changedflags;	/* Set by imapscan_open */
	} ;

/*
** Stuff we want to know about the maildir.
*/

struct imapscaninfo {
	unsigned long nmessages;	/* # of messages */
	unsigned long uidv;		/* See RFC 2060 */
	unsigned long left_unseen;
	unsigned long nextuid;
	struct imapscanmessageinfo *msgs;
	struct maildirwatch *watcher;
	} ;

/*
** In imapscan_maildir, move the following msgs to cur.
*/

struct uidplus_info {
	struct uidplus_info *next;
	char *tmpfilename;
	char *curfilename;
	unsigned long uid; /* Initialized by imapscan_maildir2 */
	unsigned long old_uid; /* Initialized by do_copy() */
} ;


void imapscan_init(struct imapscaninfo *p);
void imapscan_copy(struct imapscaninfo *a,
		   struct imapscaninfo *b);

int imapscan_maildir(struct imapscaninfo *, const char *, int, int,
		     struct uidplus_info *);
void imapscan_free(struct imapscaninfo *);

int imapscan_openfile(const char *, struct imapscaninfo *, unsigned);

char *readline(unsigned, FILE *);

#endif
