#ifndef	numlib_h
#define	numlib_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#ifdef	__cplusplus
extern "C" {
#endif

static const char numlib_h_rcsid[]="$Id: numlib.h,v 1.4 2002/07/11 12:03:20 mrsam Exp $";

#if	HAVE_CONFIG_H
#include	"config.h"
#endif

#include	<sys/types.h>
#include	<time.h>

#define	NUMBUFSIZE	60

/* Convert various system types to decimal */

char	*str_time_t(time_t, char *);
char	*str_off_t(off_t, char *);
char	*str_pid_t(pid_t, char *);
char	*str_ino_t(ino_t, char *);
char	*str_uid_t(uid_t, char *);
char	*str_gid_t(gid_t, char *);
char	*str_size_t(size_t, char *);

char	*str_sizekb(unsigned long, char *);	/* X Kb or X Mb */

/* Convert selected system types to hex */

char	*strh_time_t(time_t, char *);
char	*strh_pid_t(pid_t, char *);
char	*strh_ino_t(ino_t, char *);

/*
** The following functions are used by root to reset its user and group id
** to the authenticated user's.  Various functions are provided to handle
** various situations.
*/

void authchangegroup(gid_t);	/* Set the group id only.  Also clear any
				** auxiliary group ids */

void authchangeuidgid(uid_t, gid_t);
				/* Set both user id and group id.  Also clear
				** aux group ids */

void authchangeusername(const char *, const gid_t *);
	/*
	** Set the userid to the indicate user's.  If second argument is
	** not null, it points to the groupid to set.  If it's null, the
	** group id is taken from the passwd file.  Auxiliary IDs are set
	** to any aux IDs set for the user in the group file.  If there are
	** no aux group IDs for the user, any AUX ids are cleared.
	*/

#ifdef	__cplusplus
}
#endif
#endif
