/*
** Copyright 1998 - 2002 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if HAVE_DIRENT_H
#include <dirent.h>
#define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#define dirent direct
#define NAMLEN(dirent) (dirent)->d_namlen
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#if HAVE_NDIR_H
#include <ndir.h>
#endif
#endif
#if	HAVE_UTIME_H
#include	<utime.h>
#endif
#if TIME_WITH_SYS_TIME
#include	<sys/time.h>
#include	<time.h>
#else
#if HAVE_SYS_TIME_H
#include	<sys/time.h>
#else
#include	<time.h>
#endif
#endif
#if HAVE_LOCALE_H
#include	<locale.h>
#endif

#include	<sys/types.h>
#include	<sys/stat.h>

#include	"imaptoken.h"
#include	"imapwrite.h"
#include	"imapscanclient.h"

#include	"mysignal.h"
#include	"imapd.h"
#include	"fetchinfo.h"
#include	"searchinfo.h"
#include	"storeinfo.h"
#include	"mailboxlist.h"
#include	"thread.h"

#include	"authlib/authmod.h"

#include	"maildir/maildircreate.h"
#include	"maildir/maildirrequota.h"
#include	"maildir/maildirgetquota.h"
#include	"maildir/maildirquota.h"
#include	"maildir/maildirmisc.h"

#include	"unicode/unicode.h"

#define	SHARED	"shared"

static const char rcsid[]="$Id: imapd.c,v 1.71 2002/01/08 13:27:18 mrsam Exp $";

extern time_t rfc822_parsedt(const char *);
extern void fetchflags(unsigned long);
extern unsigned long header_count, body_count;

extern int do_fetch(unsigned long, int, void *);
extern int do_copy(unsigned long, int, void *);
extern int do_copy_quota_calc(unsigned long, int, void *);
extern void mainloop();
extern void capability();

char *current_mailbox=0;

FILE *debugfile=0;
int flat_folders=0;
#if 0
char *imapscanpath;
#endif

struct imapscaninfo current_mailbox_info;
int current_mailbox_ro;

void rfc2045_error(const char *p)
{
	write(2, p, strlen(p));
	_exit(0);
}


extern int maildirsize_read(const char *,int *,off_t *,unsigned *,unsigned *,struct stat *);

void quotainfo_out(const char* qroot)
{
	char    quotabuf[QUOTABUFSIZE];
	char	qresult[200]="";
	char	qbuf[200];
	
	if ((maildir_getquota(".", quotabuf) == 0) && (strcmp(qroot,"SHARED") != 0))
	{
	int	quotafd;
	int	i,quota_s=-1,quota_c=-1;
	char    *quota=quotabuf;
	off_t		maildirsize_size=0;
	unsigned	maildirsize_cnt=0;
	unsigned	dummy;
	struct	stat	stat_buf;

		(void) maildir_checkquota(".", &quotafd, quotabuf, 0, 0);
		if (quotafd >= 0)	close(quotafd);

		if (maildirsize_read("maildirsize",&quotafd,
			&maildirsize_size,&maildirsize_cnt,&dummy,&stat_buf) == 0)
			close(quotafd);

		while (quota && *quota)
		{
			if (*quota < '0' || *quota > '9')
			{
				++quota;
				continue;
			}

			i=0;
			while (*quota >= '0' && *quota <= '9')
				i=i*10 + (*quota++ - '0');
			switch (*quota) 
			{
				case 'S': quota_s=i; break;
				case 'C': quota_c=i; break;
				default : break;
			}
		}
			
		if (quota_s != -1)
		{
			sprintf(qbuf,"STORAGE %d %d",((int)maildirsize_size+1023)/1024,(quota_s+1023)/1024);
			strcat(qresult,qbuf);
		}
		if (quota_c != -1)
		{
			sprintf(qbuf,"MESSAGE %d %d",maildirsize_cnt,quota_c);
			if (strcmp(qresult,"")!=0) strcat(qresult," ");
			strcat(qresult,qbuf);
		}
		
	}

	writes("* ");
	writes("QUOTA \"");
	writes(qroot);
	writes("\"");
	if (strcmp(qresult,"")!=0)
	{
		writes(" (");
		writes(qresult);
		writes(")");
	};
	writes("\r\n");
}

int is_trash(const char *m)
{
	if (strcmp(m, "." TRASH))
	{
		/*
		 * not trying to delete .Trash but folder inside of .Trash
		 */
		return (0);
	}
	else
	{
		/*
		 * trying to delete .Trash - stop them
		 */
		return (1);
	}
}

void emptytrash()
{
	char	*dir, *all_settings, *next_folder, *folder, *p;
	unsigned l;

	all_settings=getenv("IMAP_EMPTYTRASH");

	if (!all_settings)
		return;

	all_settings=strdup(all_settings);
	if (!all_settings)
		return;

	if (strchr(all_settings, ':') == 0 &&
	    strchr(all_settings, ',') == 0)
	{
		l=atoi(all_settings);

		if (l <= 0)
			l=1;

		maildir_getnew(".", TRASH);
		if ((dir=maildir_folderdir(".", TRASH)))
		{
			maildir_purge(dir, l * 24 * 60 * 60);
			free(dir);
		}
		free(all_settings);
		return;
	}

	for (folder=all_settings; folder && *folder; )
	{
		if (*folder == ',')
		{
			++folder;
			continue;
		}
		next_folder=strchr(folder, ',');
		if (next_folder)
			*next_folder++=0;

		p=strchr(folder, ':');
		if (!p)
		{
			folder=next_folder;
			continue;
		}

		*p++=0;

		l=atoi(p);
		if (l <= 0)	l=1;

		maildir_getnew(".", folder);
		if ((dir=maildir_folderdir(".", folder)))
		{
			maildir_purge(dir, l * 24 * 60 * 60);
			free(dir);
		}
		folder=next_folder;
	}
	free(all_settings);
}

#if 0
int is_draft(const char *m)
{
#if 1
	/* Fix some PINE bugs first */

	if (strcmp(m, "." DRAFTS))	return (0);
	return (1);
#else
	return (0);
#endif
}
#endif

int is_reserved(const char *m)
{
	if (is_trash(m))	return (1);
	return (0);
}

/* The namespace arg is used to select special options */

char *set_namespace_options(char *p)
{
char	*q;

	flat_folders=0;
	if (*p != '#')	return (p);
	if ((q=strchr(p, '.')) == 0)
		return (0);
	*q++='\0';
	for (++p; (p=strtok(p, ",")) != 0; p=0)
	{
		if (strcmp(p, "allfolders") == 0)
		{
			flat_folders=1;
			continue;
		}
		return (0);
	}
	return (q);
}

char *valid_mailbox_name(const char *m, int accept_shared)
{
char	*p=malloc(strlen(m)+1);
char	*arg;

	if (!p)	write_error_exit(0);
	strcpy(p, m);

	arg=set_namespace_options(p);

	if (arg && (strchr(arg, '%') || strchr(arg, '*') || strchr(arg, '/')))
		arg=0;

	if (!arg)
	{
		free(p);
		return (0);
	}

	if (accept_shared && strncmp(arg, SHARED, sizeof(SHARED)-1) == 0)
	{
		arg += sizeof(SHARED)-1;

		/* We need to specialcase "shared" and "shared.name".
		** maildir_shareddir will return NULL for these cases, because
		** it will insist on "name.folder", but we need to return a
		** non NULL value to indicate that this is a valid hierarchy
		** name.  We return a special value of an empty string, which
		** is checked for in situations where a valid folder is
		** required.
		*/

		if (*arg && *arg != '.')
		{
			arg=0;
			errno=EINVAL;
		}
		else if (*arg == 0 || strchr(arg+1, '.') == 0)
		{
			arg=malloc(1);
			if (!arg)	write_error_exit(0);
			*arg=0;
		}
		else
			arg=maildir_shareddir(0, arg+1);
	}
	else
	{
#if	HAVE_STRNCASECMP
		if (strncasecmp(arg, INBOX, sizeof(INBOX)-1))
#else
		if (strnicmp(arg, INBOX, sizeof(INBOX)-1))
#endif
		{
			free(p);
			return (0);
		}

		arg += sizeof(INBOX)-1;

		if (*arg == 0)
			arg=maildir_folderdir(0, 0);
		else if (*arg++ != '.')
		{
			free(p);
			return (0);
		}
		else
			arg=maildir_folderdir(0, arg);
	}

	if (!arg && errno != EINVAL)
	{
		free(p);
		write_error_exit(0);
	}
	free(p);
	return (arg);
}

char *decode_valid_mailbox(const char *p, int autosubscribe)
{
char	*q;
char	*r;

	q=valid_mailbox_name(p, 1);
	if (!q)	return (q);

	if (*q == 0)
		return (0);

	r=malloc(strlen(q)+sizeof("/."));
	if (!r)	write_error_exit(0);
	strcat(strcpy(r, q), "/.");
	if (access(r, 0))
	{

		if (autosubscribe && is_sharedsubdir(r))
		{
			/*
			** automatically SUBSCRIBE to this folder, if needed
			** (Pine)
			*/

		char	*p=malloc(strlen(r)), *qq;

			/* A little overkill, that's ok */

			if (!p)	write_error_exit(0);

			strcpy(p, strchr(r, '/')+1);
			if ((qq=strchr(p, '/')) != 0)
				*qq='.';

			if ((qq=strchr(p, '/')) != 0)
				*qq=0;		/* Chop off trailing /. */

			(void)maildir_shared_subscribe(0, p);
			free(p);
			if (access(r, 0) == 0)
			{
				free(r);
				return(q);
			}
		}
		free(r);
		free(q);
		return (0);
	}
	free(r);
	return (q);
}

static time_t decode_date_time(char *p)
{
unsigned	i;

	/* Convert to format rfc822_parsedt likes */

	for (i=1; p[i] != ' '; i++)
	{
		if (!p[i])	return (0);
		if (p[i] == '-')	p[i]=' ';
	}
	return (rfc822_parsedt(p));
}

int get_flagname(const char *p, struct imapflags *flags)
{
	if (strcmp(p, "\\SEEN") == 0)
		flags->seen=1;
	else if (strcmp(p, "\\ANSWERED") == 0)
		flags->answered=1;
	else if (strcmp(p, "\\DRAFT") == 0)
		flags->drafts=1;
	else if (strcmp(p, "\\DELETED") == 0)
		flags->deleted=1;
	else if (strcmp(p, "\\FLAGGED") == 0)
		flags->flagged=1;
	else return (-1);
	return (0);
}

int get_flags(struct imapflags *flags)
{
struct imaptoken *t;

	while ((t=nexttoken())->tokentype == IT_ATOM)
	{
		get_flagname(t->tokenbuf, flags);
	}
	return (t->tokentype == IT_RPAREN ? 0:-1);
}

void get_message_flags(
	struct imapscanmessageinfo *mi,
	char *buf, struct imapflags *flags)
{
const char *filename=mi->filename;

	if (buf)
		*buf=0;

	if (flags)
		flags->seen=flags->answered=flags->deleted=flags->flagged
		=flags->recent=flags->drafts=0;

	if ((filename=strrchr(filename, ':')) == 0
		|| strncmp(filename, ":2,", 3))	return;

	if (strchr(filename, 'D'))
	{
		if (buf) strcat(buf, "\\Draft");
		if (flags)  flags->drafts=1;
	}

	if (strchr(filename, 'F'))
	{
		if (buf) strcat(strcat(buf, *buf ? " ":""), "\\Flagged");
		if (flags)	flags->flagged=1;
	}
	if (strchr(filename, 'R'))
	{
		if (buf) strcat(strcat(buf, *buf ? " ":""), "\\Answered");
		if (flags)	flags->answered=1;
	}
	if (strchr(filename, 'S'))
	{
		if (buf) strcat(strcat(buf, *buf ? " ":""), "\\Seen");
		if (flags)	flags->seen=1;
	}
	if (strchr(filename, 'T'))
	{
		if (buf) strcat(strcat(buf, *buf ? " ":""), "\\Deleted");
		if (flags)	flags->deleted=1;
	}

	if (mi->recentflag)
	{
		if (flags) flags->recent=1;
		if (buf) strcat(strcat(buf, *buf ? " ":""), "\\Recent");
	}
}

static char *parse_mailbox_error(const char *tag,
	struct imaptoken *curtoken,
	int ok_hierarchy,	/* RFC 2060 errata - DELETE can take
				** a trailing hierarchy separator if the
				** IMAP server supports subfolders of
				** a real folder (such as this one).
				*/

	int autosubscribe)	/* Really DUMP clients that do a LIST,
				** and don't bother to check if a folder is
				** subscribed to, or not (Pine)
				*/
{
char	*mailbox;

	if (curtoken->tokentype != IT_NUMBER &&
		curtoken->tokentype != IT_ATOM &&
		curtoken->tokentype != IT_QUOTED_STRING)
	{
		mailbox=0;
	}
	else
	{
		if (ok_hierarchy && (mailbox=strrchr(curtoken->tokenbuf,
			HIERCH)) && mailbox[1] == 0)
				*mailbox=0;

		mailbox=decode_valid_mailbox(curtoken->tokenbuf,
			autosubscribe);
	}

	if ( mailbox == 0)
	{
		writes(tag);
		writes(" NO Invalid mailbox\r\n");
		return (0);
	}
	return (mailbox);
}

/*
		STORE NEW MESSAGE INTO A MAILBOX
*/

void append_flags(char *buf, struct imapflags *flags)
{
	if (flags->drafts)	strcat(buf, "D");
	if (flags->flagged)	strcat(buf, "F");
	if (flags->answered)	strcat(buf, "R");
	if (flags->seen)	strcat(buf, "S");
	if (flags->deleted)	strcat(buf, "T");
}

	/* First, figure out the filenames used in tmp and new */

void maildir_mkfilename(const char *mailbox, struct imapflags *flags,
	unsigned long s, char **tmpname, char **newname)
{
char	*p;
char	uniqbuf[80];
static unsigned uniqcnt;
int	rc;

	sprintf(uniqbuf, "%u", uniqcnt++);

	while ((rc=maildir_try_create_hostname(mailbox, uniqbuf, s, getenv("HOSTNAME"),
		tmpname, newname)))
	{
		if (rc < 0)	write_error_exit(0);
		sleep(3);
	}

	strcpy(uniqbuf, ":2,");
	append_flags(uniqbuf, flags);

	if (uniqbuf[3] == 0 &&	/* No flags, messages goes into new */

		/* Even if there's no flags, if we're moving a message into
		** a sharable folder, put it into cur
		*/

		!is_sharedsubdir(mailbox))
			return;

	/* Ok, this message will really go to cur, not new */

	p=malloc(strlen(*newname)+strlen(uniqbuf)+1);
	if (!p)	write_error_exit(0);
	strcpy(p, *newname);
	memcpy(strrchr(p, '/')-3, "cur", 3);	/* HACK OF THE MILLENIA */
	strcat(p, uniqbuf);
	free(*newname);
	*newname=p;
}

static int store_mailbox(const char *tag, const char *mailbox,
	struct	imapflags *flags,
	time_t	timestamp,
	unsigned long nbytes)
{
char	*tmpname;
char	*newname;
char	*p;
FILE	*fp;
unsigned long n;
char	quotabuf[QUOTABUFSIZE];
int	fd;
static const char nowrite[]=" NO [ALERT] Cannot create message - no write permission or out of disk space.\r\n";
int	rc;
int	lastnl;

	maildir_mkfilename(mailbox, flags, 0, &tmpname, &newname);

	fd=maildir_safeopen(tmpname, O_RDWR|O_CREAT|O_EXCL, 0644);
	fp=0;
	if (fd >= 0)
	{
		fp=fdopen(fd, "w");
		if (!fp)
		{
			close(fd);
			unlink(tmpname);
			fd= -1;
		}
	}

	if (fd < 0)
	{
		writes(tag);
		writes(nowrite);
		free(tmpname);
		free(newname);
		return (-1);
	}
	writes("+ OK\r\n");
	writeflush();
	lastnl=0;
	while (nbytes)
	{
		read_string(&p, &n, nbytes);
		nbytes -= n;
		while (n)
		{
			if (*p != '\r')
				putc((int)(unsigned char)*p, fp);
			lastnl=0;
			if (*p == '\n')	lastnl=1;
			--n;
			++p;
		}
	}
	if (!lastnl)	putc('\n', fp);

	if (fflush(fp) || ferror(fp))
	{
		fprintf(stderr,
                        "ERR: error storing a message, user=%s, errno=%d\n",
                                getenv("AUTHENTICATED"), errno);

		fclose(fp);
		close(fd);
		unlink(tmpname);
		writes(tag);
		writes(nowrite);
		free(tmpname);
		free(newname);
		return (-1);
	}

	nbytes=ftell(fp);
	if (nbytes == (unsigned long)-1 ||
		(p=maildir_requota(newname, nbytes)) == 0)
		
	{
		fclose(fp);
		close(fd);
		unlink(tmpname);
		writes(tag);
		writes(nowrite);
		free(tmpname);
		free(newname);
		return (-1);
	}

	free(newname);

	fclose(fp);
	close(fd);

#if	HAVE_UTIME
	if (timestamp)
	{
	struct	utimbuf ub;

		ub.actime=ub.modtime=timestamp;
		utime(tmpname, &ub);
	}
#else
#if	HAVE_UTIMES
	if (timestamp)
	{
	struct	timeval	tv;

		tv.tv_sec=timestamp;
		tv.tv_usec=0;
		utimes(tmpname, &tv);
	}
#endif
#endif
	if (!is_trash(mailbox) && maildir_getquota(mailbox, quotabuf) == 0)
	{
	int	quotafd;

		if (maildir_checkquota(mailbox, &quotafd, quotabuf, nbytes, 1)
			&& errno != EAGAIN)
		{
			if (quotafd >= 0)	close(quotafd);
			unlink(tmpname);
			free(tmpname);
			free(p);
			writes(tag);
			writes(" NO [ALERT] You exceeded your mail quota.\r\n");
			return (-1);
		}
		maildir_addquota(mailbox, quotafd, quotabuf, nbytes, 1);
		if (quotafd >= 0)	close(quotafd);
	}

	rc=rename(tmpname, p);
	if (rc)
	{
		writes(tag);
		writes(nowrite);
		unlink(tmpname);
	}
	free(tmpname);
	free(p);
	return (rc);
}


/************** Create and delete folders **************/

#if 0
static int checksubdir(const char *s)
{
DIR	*dirp;
struct	dirent *de;

	dirp=opendir(s);
	while (dirp && (de=readdir(dirp)) != 0)
		if (de->d_name[0] != '.')
		{
			closedir(dirp);
			return (1);
		}
	if (dirp)	closedir(dirp);
	return (0);
}
#endif

static int mddelete(const char *s)
{
int	rc;

	trap_signals();
	rc=maildir_mddelete(s);
	if (release_signals())	_exit(0);
	return (rc);
}

static int domdcreate(const char *a, const char *b, int isdir)
{
char	*s=malloc(strlen(a)+strlen(b)+2);

	if (!s)	return (-1);
	strcat(strcat(strcpy(s, a), "/"), b);
	if (isdir)
		mkdir(s, 0700);
	else
		close(open(s, O_CREAT|O_RDWR, 0700));
	free(s);
	return (0);
}

static int mdcreate(const char *mailbox)
{
	trap_signals();
	if (mkdir(mailbox, 0700))
	{
		if (release_signals())	_exit(0);
		return (-1);
	}

	if ( domdcreate(mailbox, "tmp", 1) ||
		domdcreate(mailbox, "new", 1) ||
		domdcreate(mailbox, "cur", 1) ||
		domdcreate(mailbox, "maildirfolder", 0))
	{
		maildir_mddelete(mailbox);
		if (release_signals())	_exit(0);
		return (-1);
	}

	if (release_signals())	_exit(0);
	return (0);
}

/****************************************************************************/

/* do_msgset parses a message set, and calls a processing func for each msg */

/****************************************************************************/

static int do_msgset(const char *msgset,
	int (*msgfunc)(unsigned long, int, void *),
	void *msgfunc_arg, int isuid)
{
unsigned long i, j;
int	rc;
unsigned long last=0;

	if (current_mailbox_info.nmessages > 0)
	{
		last=current_mailbox_info.nmessages;
		if (isuid)
		{
			last=current_mailbox_info.msgs[last-1].uid;
		}
	}

	while (isdigit((int)(unsigned char)*msgset) || *msgset == '*')
	{
		i=0;
		if (*msgset == '*')
		{
			i=last;
			++msgset;
		}
		else while (isdigit((int)(unsigned char)*msgset))
		{
			i=i*10 + (*msgset++-'0');
		}
		if (*msgset != ':')
			j=i;
		else
		{
			j=0;
			++msgset;
			if (*msgset == '*')
			{
				j=last;
				++msgset;
			}
			else while (isdigit((int)(unsigned char)*msgset))
			{
				j=j*10 + (*msgset++-'0');
			}
		}
		if (j < i)
		{
#if 0
	/* BUGS issue */
			writes("* NO Invalid message set: ");
			writen(i);
			writes(":");
			writen(j);
			writes("\r\n");
#endif
		}
		else if (isuid)
		{
		unsigned long k;

			for (k=0; k<current_mailbox_info.nmessages; k++)
				if (current_mailbox_info.msgs[k].uid >= i)
					break;
			if (k >= current_mailbox_info.nmessages ||
				current_mailbox_info.msgs[k].uid > j)
			{
#if 0
	/* BUGS issue */
				writes("* NO Invalid message: UID ");
				writen(i);
				if (j > i)
				{
					writes(":");
					writen(j);
				}
				writes("\r\n");
#endif
			}
			else while (k < current_mailbox_info.nmessages &&
				current_mailbox_info.msgs[k].uid <= j)
			{
				if ((rc=(*msgfunc)(k+1, 1, msgfunc_arg)) != 0)
					return (rc);
				++k;
			}
		}
		else
		{
			do
			{
				if (i > current_mailbox_info.nmessages)
				{
					writes("* NO Invalid message sequence number: ");
					writen(i);
					writes("\r\n");
					break;
				}

				if ((rc=(*msgfunc)(i, 0, msgfunc_arg)) != 0)
					return (rc);
			} while (i++ < j);
		}

		if (*msgset++ != ',')	break;
	}
	return (0);
}

/****************************************************************************/

/* Show how many messages are in the mailbox                                */

/****************************************************************************/

static void mailboxmetrics()
{
unsigned long i,j;

	writes("* ");
	writen(current_mailbox_info.nmessages);
	writes(" EXISTS\r\n");
	writes("* ");
	i=0;

	for (j=0; j<current_mailbox_info.nmessages; j++)
		if (current_mailbox_info.msgs[j].recentflag)
			++i;
	writen(i);
	writes(" RECENT\r\n");
}

/****************************************************************************/

/* Do the NOOP stuff                                                        */

/****************************************************************************/

static void noop()
{
struct imapscaninfo new_mailbox_info;
unsigned long i, j;
int	needstats=0;
unsigned long expunged;

	if (imapscan_maildir(&new_mailbox_info, current_mailbox, 0,
	      current_mailbox_ro))
		return;

	j=0;
	expunged=0;
	for (i=0; i<current_mailbox_info.nmessages; i++)
	{
		while (j < new_mailbox_info.nmessages &&
			new_mailbox_info.msgs[j].uid <
				current_mailbox_info.msgs[i].uid)
		{
			/* How did this happen??? */

			new_mailbox_info.msgs[j].changedflags=1;
			++j;
			needstats=1;
		}

		if (j >= new_mailbox_info.nmessages ||
			new_mailbox_info.msgs[j].uid >
				current_mailbox_info.msgs[i].uid)
		{
			writes("* ");
			writen(i+1-expunged);
			writes(" EXPUNGE\r\n");
			needstats=1;
			++expunged;
			continue;
		}

		/* Must be the same */

		if (strcmp(current_mailbox_info.msgs[i].filename,
			new_mailbox_info.msgs[j].filename))
		{
			new_mailbox_info.msgs[j].changedflags=1;
			needstats=1;
		}
		if (current_mailbox_info.msgs[i].recentflag)
			new_mailbox_info.msgs[j].recentflag=1;
		++j;
	}

	while (j < new_mailbox_info.nmessages)
	{
		new_mailbox_info.msgs[j].changedflags=1;
		++j;
		needstats=1;
	}

	imapscan_free(&current_mailbox_info);
	current_mailbox_info=new_mailbox_info;

	if (needstats)
		mailboxmetrics();

#if	IMAP_CLIENT_BUGS

	/* Netscape Messenger bug */

#else
	for (j=0; j < current_mailbox_info.nmessages; j++)
		if (current_mailbox_info.msgs[j].changedflags)
			fetchflags(j);
#endif
}

static char *alloc_filename(const char *mbox, const char *name)
{
char	*p=malloc(strlen(mbox)+strlen(name)+sizeof("/cur/"));

	if (!p)	write_error_exit(0);

	strcat(strcat(strcpy(p, mbox), "/cur/"), name);
	return (p);
}

/****************************************************************************/

/* Do the IDLE stuff                                                        */

/****************************************************************************/

extern int doidle(time_t);

static void imapidle(void)
{
const char * envp = getenv("IMAP_IDLE_TIMEOUT");
const int idleTimeout = envp ? atoi(envp) : 60;

       writes("+ entering idle mode\r\n");
       noop();
       writeflush();
       while (!doidle(idleTimeout))
       {
               noop();
               writeflush();
       }
}

/****************************************************************************/

/* Do the EXPUNGE stuff                                                     */

/****************************************************************************/

static void expunge()
{
unsigned long j;
struct imapflags flags;
char	*old_name;
int	move_to_trash=0;

	fetch_free_cache();

	old_name=getenv("IMAP_MOVE_EXPUNGE_TO_TRASH");
	if (old_name && atoi(old_name) && !is_trash(current_mailbox))
		move_to_trash=1;

	for (j=0; j < current_mailbox_info.nmessages; j++)
	{
		get_message_flags(current_mailbox_info.msgs+j, 0, &flags);

		if (!flags.deleted)
			continue;

		old_name=alloc_filename(current_mailbox,
			current_mailbox_info.msgs[j].filename);

		if (is_sharedsubdir(current_mailbox))
		{
			maildir_unlinksharedmsg(old_name);
		}
		else if (move_to_trash)
		{
		char	*new_name;
		char	*p;

			new_name=alloc_filename("." TRASH,
				current_mailbox_info.msgs[j].filename);

			/* Don't mark it as deleted in the Trash */

			if ((p=strrchr(new_name, '/')) &&
				(p=strrchr(p, ':')) &&
				strncmp(p, ":2,", 3) == 0 &&
				(p=strchr(p, 'T')))
				while ((*p=p[1]) != 0)
					++p;
			rename(old_name, new_name);
			unlink(old_name);
			/* triggers linux kernel bug if also moved to Trash by
			sqwebmail */

			free(new_name);
		}
		else
		{
			unlink(old_name);
		}
		free(old_name);
	}
}

static char *newsubscribefile()
{
char    *tmpname, *newname;
char    uniqbuf[80];
static  unsigned tmpuniqcnt=0;
int	rc;

	sprintf(uniqbuf, "imapsubscribe%u", tmpuniqcnt++);

	while ((rc=maildir_try_create_hostname(".", uniqbuf,
		0, getenv("HOSTNAME"), &tmpname, &newname)))
	{
		if (rc < 0)	write_error_exit(0);
		sleep(3);
	}

	free(newname);
	return (tmpname);
}

static int sub_strcmp(const char *a, const char *b)
{
	if (strncasecmp(a, "inbox", 5) == 0 &&
		strncasecmp(b, "inbox", 5) == 0)
	{
		a += 5;
		b += 5;
	}
	return (strcmp(a, b));
}

static void subscribe(const char *f)
{
char *newf=newsubscribefile();
FILE *newfp=fopen(newf, "w");
FILE *oldfp;

	if (!newfp)
		write_error_exit(0);

	if ((oldfp=fopen(SUBSCRIBEFILE, "r")) != 0)
	{
	char	buf[BUFSIZ];

		while (fgets(buf, sizeof(buf), oldfp) != 0)
		{
		char *p=strchr(buf, '\n');

			if (p)	*p=0;
			if (sub_strcmp(buf, f) == 0)
			{
				fclose(oldfp);
				fclose(newfp);
				unlink(newf);
				free(newf);
				return;	/* Already subscribed */
			}
			fprintf(newfp, "%s\n", buf);
		}
		fclose(oldfp);
	}
	fprintf(newfp, "%s\n", f);
	if (fflush(newfp) || ferror(newfp))
		write_error_exit(0);
	fclose(newfp);
	rename(newf, SUBSCRIBEFILE);
	free(newf);
}

static void unsubscribe(const char *f)
{
char *newf=newsubscribefile();
FILE *newfp=fopen(newf, "w");
FILE *oldfp;

	if (!newfp)
		write_error_exit(0);

	if ((oldfp=fopen(SUBSCRIBEFILE, "r")) != 0)
	{
	char	buf[BUFSIZ];

		while (fgets(buf, sizeof(buf), oldfp) != 0)
		{
		char *p=strchr(buf, '\n');

			if (p)	*p=0;
			if (sub_strcmp(buf, f) == 0)
				continue;
			fprintf(newfp, "%s\n", buf);
		}
		fclose(oldfp);
	}
	if (fflush(newfp) || ferror(newfp))
		write_error_exit(0);
	fclose(newfp);
	rename(newf, SUBSCRIBEFILE);
	free(newf);
}

/* Hierarchical rename */

static int chk_rename(const char *, const char *);
static int do_rename(const char *, const char *);

static int scan_hier_rename(const char *, const char *,
			    int (*)(const char *, const char *), int);

static int hier_rename(const char *oldname, const char *newname, int ishier)
{
	if (scan_hier_rename(oldname, newname, chk_rename, ishier))
		return (-1);

	scan_hier_rename(oldname, newname, do_rename, ishier);
	return (0);
}

static int scan_hier_rename(const char *oldname,
			    const char *newname,
			    int (*func)(const char *, const char *),
			    int ishier)
{
	int oldname_l=strlen(oldname);
	DIR *dirp;
	struct dirent *de;

	dirp=opendir(".");
	while (dirp && (de=readdir(dirp)) != 0)
	{
		char *tst_cur;

		if (de->d_name[0] != '.')
			continue;
		if (strcmp(de->d_name, "..") == 0)
			continue;

		if ((tst_cur=malloc(strlen(de->d_name)+sizeof("/cur")))
		    == NULL)
		{
			write_error_exit(0);
		}
		strcat(strcpy(tst_cur, de->d_name), "/cur");
		if (access(tst_cur, 0))
		{
			free(tst_cur);
			continue;
		}
		free(tst_cur);
		if (strncmp(de->d_name, oldname, oldname_l))
			continue;

		if (de->d_name[oldname_l] == 0)
		{
			if (ishier)
				continue;	/* Only the hierarchy */

			if ( (*func)(oldname, newname))
			{
				closedir(dirp);
				return (-1);
			}
			continue;
		}

	        if (de->d_name[oldname_l] != HIERCH)
			continue;

		if (!ishier)
			continue;

		tst_cur=malloc(strlen(newname) + strlen(de->d_name+oldname_l)
			       + 1);
		if (!tst_cur)
			write_error_exit(0);

		strcat(strcpy(tst_cur, newname), de->d_name+oldname_l);

		if ( (*func)(de->d_name, tst_cur))
		{
			free(tst_cur);
			closedir(dirp);
			return (-1);
		}
		free(tst_cur);
	}
	closedir(dirp);
	return (0);
}

static int chk_rename(const char *on, const char *nn)
{
	if (access(nn, 0) == 0)
		return (-1);	/* Destination folder exists */
	return (0);
}

static int do_rename(const char *on, const char *nn)
{
	rename(on, nn);
	return (0);
}

static int do_rename(const char *, const char *);

int do_imap_command(const char *tag)
{
struct	imaptoken *curtoken=nexttoken();
int	uid=0;

	if (curtoken->tokentype != IT_ATOM)	return (-1);

	/* Commands that work in authenticated state */

	if (strcmp(curtoken->tokenbuf, "CAPABILITY") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		capability();
		writes(tag);
		writes(" OK CAPABILITY completed\r\n");
		return (0);
	}
	if (strcmp(curtoken->tokenbuf, "NOOP") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		if (current_mailbox)
			noop();
		writes(tag);
		writes(" OK NOOP completed\r\n");
		return (0);
	}
       if (strcmp(curtoken->tokenbuf, "IDLE") == 0)
       {
               if (nexttoken()->tokentype != IT_EOL)   return (-1);
               if (current_mailbox)
               {
                       read_eol();
                       imapidle();
                       curtoken=nexttoken();
                       if (strcmp(curtoken->tokenbuf, "DONE") == 0)
                       {
                               if (current_mailbox)
                                       noop();
                               writes(tag);
                               writes(" OK IDLE completed\r\n");
                               return (0);
                       }
               }
               return (-1);
       }
	if (strcmp(curtoken->tokenbuf, "LOGOUT") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		fetch_free_cache();
		writes("* BYE Courier-IMAP server shutting down\r\n");
		writes(tag);
		writes(" OK LOGOUT completed\r\n");
		writeflush();
		emptytrash();
		fprintf(stderr, "INFO: LOGOUT, user=%s, ip=[%s],"
			" headers=%lu, body=%lu\n",
			getenv("AUTHENTICATED"), getenv("TCPREMOTEIP"),
			header_count, body_count);
		exit(0);
	}

	if (strcmp(curtoken->tokenbuf, "LIST") == 0
		|| strcmp(curtoken->tokenbuf, "LSUB") == 0)
	{
	char	*reference, *name;
	int	rc;
	char	cmdbuf[5];

		strcpy(cmdbuf, curtoken->tokenbuf);

		curtoken=nexttoken_nouc();
		if (curtoken->tokentype == IT_NIL)
			reference=my_strdup("");
		else
		{
			if (curtoken->tokentype != IT_QUOTED_STRING &&
				curtoken->tokentype != IT_ATOM &&
				curtoken->tokentype != IT_NUMBER)
				return (-1);
			reference=my_strdup(curtoken->tokenbuf);
		}
		curtoken=nexttoken_nouc();

		if (curtoken->tokentype == IT_NIL)
			name=my_strdup("");
		else
		{
			if (curtoken->tokentype != IT_QUOTED_STRING &&
				curtoken->tokentype != IT_ATOM &&
				curtoken->tokentype != IT_NUMBER)
				return (-1);
			name=my_strdup(curtoken->tokenbuf);
		}
		if (nexttoken()->tokentype != IT_EOL)	return (-1);

		rc=mailbox_list(tag, reference, name, cmdbuf);
		free(reference);
		free(name);
		if (rc == 0)
		{
			writes(tag);
			writes(" OK ");
			writes(cmdbuf);
#if IMAP_CLIENT_BUGS

		/* Sun StarOffice 5.1a bug (what are these guys smoking?) */

			writes(" completed.\r\n");
#else
			writes(" completed\r\n");
#endif
		}
		writeflush();
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "APPEND") == 0)
	{
	char	*mailbox;
	struct	imapflags flags;
	time_t	timestamp=0;
	struct	imaptoken *tok=nexttoken_nouc();

		if (tok->tokentype != IT_NUMBER &&
			tok->tokentype != IT_ATOM &&
			tok->tokentype != IT_QUOTED_STRING)
			return (-1);

		mailbox=valid_mailbox_name(tok->tokenbuf, 0);
		if(mailbox && access(mailbox, 0)) {
		      writes(tag);
		      writes(" NO [TRYCREATE] Must create mailbox before append\r\n");
		      free(mailbox);
		      return (0);
		}

		if (mailbox)
		{
			free(mailbox);
		}

		mailbox=parse_mailbox_error(tag, tok, 0, 1);
		if ( mailbox == 0)
			return (0);
		if (current_mailbox &&
			strcmp(mailbox, current_mailbox) == 0 &&
			current_mailbox_ro)
		{
			free(mailbox);
			writes(tag);
			writes(" NO Current box is selected READ-ONLY.\r\n");
			return (0);
		}

		if (strncmp(tok->tokenbuf, SHARED HIERCHS,
				sizeof(SHARED HIERCHS)-1) == 0)
		{
				/* append to the original sharable folder */

		char	*p=malloc(strlen(mailbox)+sizeof("/shared"));

			if (!p)	write_error_exit(0);

			strcat(strcpy(p, mailbox), "/shared");
			free(mailbox);
			mailbox=p;
		}

		curtoken=nexttoken_noparseliteral();
		memset(&flags, 0, sizeof(flags));
		if (curtoken->tokentype == IT_LPAREN)
		{
			if (get_flags(&flags))
			{
				free(mailbox);
				return (-1);
			}
			curtoken=nexttoken_noparseliteral();
		}
		else if (curtoken->tokentype == IT_ATOM)
		{
		char	*p;

			for (p=curtoken->tokenbuf; *p; ++p)
				*p=toupper(*p);

			get_flagname(curtoken->tokenbuf, &flags);
			curtoken=nexttoken_noparseliteral();
		}
		else if (curtoken->tokentype == IT_NIL)
			curtoken=nexttoken_noparseliteral();

		if (curtoken->tokentype == IT_QUOTED_STRING)
		{
			timestamp=decode_date_time(curtoken->tokenbuf);
			if (timestamp == 0)
			{
				free(mailbox);
				return (-1);
			}
			curtoken=nexttoken_noparseliteral();
		}
		else if (curtoken->tokentype == IT_NIL)
			curtoken=nexttoken_noparseliteral();

		if (curtoken->tokentype != IT_LITERAL_STRING_START)
			return (-1);

		if (store_mailbox(tag, mailbox, &flags, timestamp,
			curtoken->tokennum))
		{
			unread('\n');
			return (0);
		}

		if (nexttoken()->tokentype != IT_EOL)	return (-1);

		writes(tag);
		writes(" OK APPEND Ok.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "GETQUOTAROOT") == 0)
	{
	char	*mailbox;
	char	qroot[20]="ROOT";
	
		curtoken=nexttoken_nouc();
		mailbox=parse_mailbox_error(tag, curtoken, 0, 1);
		if ( mailbox == 0)
			return (0);
		if (is_sharedsubdir(mailbox))
			strcpy(qroot,"SHARED");

		writes("*");
		writes(" QUOTAROOT \"");
		writeqs(mailbox);
		writes("\" \"");
		writes(qroot);
		writes("\"\r\n");
		quotainfo_out(qroot);
		writes(tag);
		writes(" OK GETQUOTAROOT Ok.\r\n");
		return(0);
	}


	if (strcmp(curtoken->tokenbuf, "SETQUOTA") == 0)
	{
		writes(tag);
		writes(" NO SETQUOTA No permission.\r\n");
		return(0);
	}

	if (strcmp(curtoken->tokenbuf, "GETQUOTA") == 0)
	{
		curtoken=nexttoken_nouc();
#if IMAP_CLIENT_BUGS
		/* allow any quota root name */
#else
		if ((strcmp(curtoken->tokenbuf, "ROOT") != 0)&&
		    (strcmp(curtoken->tokenbuf, "SHARED") != 0))
		{
			writes(tag);
			writes(" BAD GETQUOTA No such Quota Root.\r\n");
			return(0);
		}
#endif
		quotainfo_out(curtoken->tokenbuf);
		writes(tag);
		writes(" OK GETQUOTA Ok.\r\n");
		return(0);
	}

	if (strcmp(curtoken->tokenbuf, "STATUS") == 0)
	{
	char	*mailbox;
	int	get_messages=0,
		get_recent=0,
		get_uidnext=0,
		get_uidvalidity=0,
		get_unseen=0;
	struct imapscaninfo other_info, *loaded_infoptr, *infoptr;
	const char *p;
	char	*orig_mailbox;
	int	oneonly;

		curtoken=nexttoken_nouc();
		mailbox=parse_mailbox_error(tag, curtoken, 0, 1);
		if ( mailbox == 0)
			return (0);

		orig_mailbox=my_strdup(curtoken->tokenbuf);
		curtoken=nexttoken();

		oneonly=0;
		if (curtoken->tokentype != IT_LPAREN)
		{
			if (curtoken->tokentype != IT_ATOM)
			{
				free(mailbox);
				free(orig_mailbox);
				return (-1);
			}
			oneonly=1;
		}
		else	nexttoken();

		while ((curtoken=currenttoken())->tokentype == IT_ATOM)
		{
			if (strcmp(curtoken->tokenbuf, "MESSAGES") == 0)
				get_messages=1;
			if (strcmp(curtoken->tokenbuf, "RECENT") == 0)
				get_recent=1;
			if (strcmp(curtoken->tokenbuf, "UIDNEXT") == 0)
				get_uidnext=1;
			if (strcmp(curtoken->tokenbuf, "UIDVALIDITY") == 0)
				get_uidvalidity=1;
			if (strcmp(curtoken->tokenbuf, "UNSEEN") == 0)
				get_unseen=1;
			nexttoken();
			if (oneonly)	break;
		}

		if ((!oneonly && curtoken->tokentype != IT_RPAREN) ||
			nexttoken()->tokentype != IT_EOL)
		{
			free(mailbox);
			free(orig_mailbox);
			return (-1);
		}

		if (current_mailbox && strcmp(current_mailbox, mailbox) == 0)
		{
			loaded_infoptr=0;
			infoptr= &current_mailbox_info;
		}
		else
		{
			loaded_infoptr= &other_info;
			infoptr=loaded_infoptr;

			if (imapscan_maildir(infoptr, mailbox, 1, 1))
			{
				writes(tag);
				writes(" NO [ALERT] STATUS failed\r\n");
				free(mailbox);
				free(orig_mailbox);
				return (0);
			}
		}

		writes("*");
		writes(" STATUS \"");
		writeqs(orig_mailbox);
		writes("\" (");
		p="";
		if (get_messages)
		{
			writes("MESSAGES ");
			writen(infoptr->nmessages+infoptr->left_unseen);
			p=" ";
		}
		if (get_recent)
		{
		unsigned long n=infoptr->left_unseen;
		unsigned long i;

			for (i=0; i<infoptr->nmessages; i++)
				if (infoptr->msgs[i].recentflag)
					++n;
			writes(p);
			writes("RECENT ");
			writen(n);
			p=" ";
		}

		if (get_uidnext)
		{
			writes(p);
			writes("UIDNEXT ");
			writen(infoptr->nextuid);
			p=" ";
		}

		if (get_uidvalidity)
		{
			writes(p);
			writes("UIDVALIDITY ");
			writen(infoptr->uidv);
			p=" ";
		}

		if (get_unseen)
		{
		unsigned long n=infoptr->left_unseen, i;

			for (i=0; i<infoptr->nmessages; i++)
			{
			const char *p=infoptr->msgs[i].filename;

				p=strrchr(p, ':');
				if (p && strncmp(p, ":2,", 3) == 0 &&
					strchr(p, 'S'))	continue;
				++n;
			}
			writes(p);
			writes("UNSEEN ");
			writen(n);
		}
		writes(")\r\n");
		if (loaded_infoptr)
			imapscan_free(loaded_infoptr);
		free(mailbox);
		free(orig_mailbox);
		writes(tag);
		writes(" OK STATUS Completed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "CREATE") == 0)
	{
	char	*mailbox, *orig_mailbox, *p;
	int	isdummy;

		curtoken=nexttoken_nouc();

		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		isdummy=0;

		p=strrchr(curtoken->tokenbuf, HIERCH);
		if (p && p[1] == '\0')
		{
			*p=0;
			isdummy=1;	/* Ignore hierarchy creation */
		}
		mailbox=valid_mailbox_name(curtoken->tokenbuf, 0);
		if (!mailbox)
		{
			writes(tag);
			writes(" NO Invalid mailbox name\r\n");
			return (0);
		}

		if (*mailbox == 0 || strncmp(curtoken->tokenbuf, SHARED HIERCHS,
			sizeof(SHARED HIERCHS)-1) == 0)
		{
			free(mailbox);
			writes(tag);
			writes(" NO SUBSCRIBE, don't CREATE a shared folder.\r\n");
			return (0);
		}

		if (isdummy)	*p=HIERCH;
		orig_mailbox=my_strdup(curtoken->tokenbuf);

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(mailbox);
			free(orig_mailbox);
			return (-1);
		}

		if (!isdummy)
		{
			if (is_reserved(mailbox) || mdcreate(mailbox))
			{
				free(mailbox);
				free(orig_mailbox);
				writes(tag);
				writes(" NO Cannot create this folder.\r\n");
				return (0);
			}
		}
		writes(tag);
		writes(" OK \"");
		writeqs(orig_mailbox);
		writes("\" created.\r\n");
		free(mailbox);
		free(orig_mailbox);
		return (0);
	}
	if (strcmp(curtoken->tokenbuf, "DELETE") == 0)
	{
	char	*mailbox;
	char	*p;
	char	*mailbox_name;

		curtoken=nexttoken_nouc();

		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		p=strrchr(curtoken->tokenbuf, HIERCH);
		if (p && p[1] == '\0')		/* Ignore hierarchy DELETE */
		{
			if (nexttoken()->tokentype != IT_EOL)
				return (-1);
			writes(tag);
			writes(" OK Folder directory delete punted.\r\n");
			return (0);
		}

		mailbox_name=my_strdup(curtoken->tokenbuf);
		mailbox=parse_mailbox_error(tag, curtoken, 1, 0);
		if ( mailbox == 0)
		{
			free(mailbox_name);
			return (0);
		}

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(mailbox_name);
			free(mailbox);
			return (-1);
		}

		if (current_mailbox && strcmp(mailbox, current_mailbox) == 0)
		{
			free(mailbox_name);
			free(mailbox);
			writes(tag);
			writes(" NO Cannot delete selected folder.\r\n");
			return (0);
		}

		if (strncmp(curtoken->tokenbuf, SHARED HIERCHS,
			sizeof(SHARED HIERCHS)-1) == 0)
		{
			free(mailbox_name);
			free(mailbox);
			writes(tag);
			writes(" NO UNSUBSCRIBE, don't DELETE a shared folder.\r\n");
			return (0);
		}

		fetch_free_cache();
		if (strcmp(mailbox, ".") == 0 ||
			is_reserved(mailbox) || mddelete(mailbox))
		{
			free(mailbox_name);
			free(mailbox);
			writes(tag);
			writes(" NO Cannot delete this folder.\r\n");
			return (0);
		}

		/* Automatically UNSUBSCRIBE a DELETEd mailbox */

		unsubscribe(mailbox_name);

		free(mailbox_name);
		free(mailbox);
		writes(tag);
		writes(" OK Folder deleted.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "RENAME") == 0)
	{
	char	*mailbox, *new_mailbox;
	char	*p;

		curtoken=nexttoken_nouc();

		if (curtoken->tokentype != IT_NUMBER &&
		    curtoken->tokentype != IT_ATOM &&
		    curtoken->tokentype != IT_QUOTED_STRING)
		{
			writes(tag);
			writes(" NO Invalid mailbox\r\n");
			return (0);
		}

		if ((p=strrchr(curtoken->tokenbuf, HIERCH))  && p[1] == 0)
			*p=0;

		mailbox=valid_mailbox_name(curtoken->tokenbuf, 0);
		if ( mailbox == 0)
			return (0);
		if (strncmp(curtoken->tokenbuf, SHARED HIERCHS,
			sizeof(SHARED HIERCHS)-1) == 0)
		{
			free(mailbox);
			writes(tag);
			writes(" NO Can't RENAME a shared folder.\r\n");
			return (0);
		}

		curtoken=nexttoken_nouc();
		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
		{
			free(mailbox);
			return (-1);
		}

		if ((p=strrchr(curtoken->tokenbuf, HIERCH)) && p[1] == 0)
		{
			*p=0;
		}

		if ((new_mailbox=valid_mailbox_name(curtoken->tokenbuf, 0))
			== 0)
		{
			free(mailbox);
			return (-1);
		}

		if (*new_mailbox == 0 ||
			strncmp(curtoken->tokenbuf, SHARED HIERCHS,
				sizeof(SHARED HIERCHS)-1) == 0)
		{
			free(new_mailbox);
			free(mailbox);
			writes(tag);
			writes(" NO Can't RENAME to a shared folder!\r\n");
			return (0);
		}


		if (nexttoken()->tokentype != IT_EOL)
		{
			free(new_mailbox);
			free(mailbox);
			return (-1);
		}

		fetch_free_cache();
		if (strcmp(mailbox, "."))
		{
			if (is_reserved(mailbox) || is_reserved(new_mailbox))
			{
				free(mailbox);
				free(new_mailbox);
				writes(tag);
				writes(" NO Cannot rename this folder.\r\n");
				return (0);
			}

			/* rename recursive: all subfolder */
			if (hier_rename(mailbox, new_mailbox, 1))
			{
				free(mailbox);
				free(new_mailbox);
				writes(tag);
				writes(" NO Cannot rename this folder.\r\n");
				return (0);
			}
			/* rename the base folder */
			if (hier_rename(mailbox, new_mailbox, 0))
			{
				free(mailbox);
				free(new_mailbox);
				writes(tag);
				writes(" NO Cannot rename this folder.\r\n");
				return (0);
			}
		}
		else	/* Renaming INBOX not yet supported */
		{
			writes(tag);
			writes(" NO This feature is not yet supported.\r\n");
			free(mailbox);
			free(new_mailbox);
			return (0);
		}
		writes(tag);
		writes(" OK Folder renamed.\r\n");
		free(mailbox);
		free(new_mailbox);
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "SELECT") == 0 ||
		strcmp(curtoken->tokenbuf, "EXAMINE") == 0)
	{
	char	*mailbox;
	int	ro=curtoken->tokenbuf[0] == 'E';

		curtoken=nexttoken_nouc();
		mailbox=parse_mailbox_error(tag, curtoken, 0, 1);
		if ( mailbox == 0)
			return (0);

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(mailbox);
			return (-1);
		}

		if (current_mailbox)
		{
			free(current_mailbox);
			imapscan_free(&current_mailbox_info);
			current_mailbox=0;
		}
		if (imapscan_maildir(&current_mailbox_info, mailbox, 0, ro))
		{
			free(mailbox);
			writes(tag);
			writes(" NO Unable to open this mailbox.\r\n");
			return (0);
		}
		current_mailbox=mailbox;

		/* check if this is a shared read-only folder */

		if (is_sharedsubdir(mailbox) &&
			maildir_sharedisro(mailbox))
			ro=1;

		current_mailbox_ro=ro;

		writes("* FLAGS (\\Draft \\Answered \\Flagged"
		       " \\Deleted \\Seen \\Recent)\r\n");
		writes("* OK [PERMANENTFLAGS (");


		if (ro)
		{
			writes(")] No permanent flags permitted\r\n");
		}
		else
		{
			writes("\\Draft \\Answered \\Flagged \\Deleted \\Seen)] Limited\r\n");
		}
		mailboxmetrics();
		writes("* OK [UIDVALIDITY ");
		writen(current_mailbox_info.uidv);
		writes("] Ok\r\n");
		writes(tag);
		writes(ro ? " OK [READ-ONLY] Ok\r\n":" OK [READ-WRITE] Ok\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "SUBSCRIBE") == 0)
	{
	char	*mailbox;
	char	*dir;
	char	*p;

		curtoken=nexttoken_nouc();
		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		p=strrchr(curtoken->tokenbuf, HIERCH);
		if (p && p[1] == '\0')		/* Ignore hierarchy DELETE */
		{
			if (nexttoken()->tokentype != IT_EOL)
				return (-1);
			writes(tag);
			writes(" OK Folder directory subscribe punted.\r\n");
			return (0);
		}

		mailbox=my_strdup(curtoken->tokenbuf);
		if (nexttoken()->tokentype != IT_EOL)
			return (-1);

		dir=valid_mailbox_name(mailbox, 1);

		if (dir && !is_sharedsubdir(dir))
		{
			subscribe(mailbox);
			free(mailbox);
			free(dir);
			writes(tag);
			writes(" OK Folder subscribed.\r\n");
			return (0);
		}
		if (dir && (*dir == 0 || access(dir, 0) == 0))
		{
			free(dir);
			free(mailbox);
			writes(tag);
			writes(" OK Already subscribed.\r\n");
			return (0);
		}

		if (!dir || maildir_shared_subscribe(0, mailbox+7))
		{
			free(mailbox);
			writes(tag);
			writes(" NO Cannot subscribe to this folder.\r\n");
			return (0);
		}
		free(dir);
		free(mailbox);
		writes(tag);
		writes(" OK SUBSCRIBE completed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "UNSUBSCRIBE") == 0)
	{
	char	*mailbox, *dir;
	char	*p;

		curtoken=nexttoken_nouc();
		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		p=strrchr(curtoken->tokenbuf, HIERCH);
		if (p && p[1] == '\0')		/* Ignore hierarchy DELETE */
		{
			if (nexttoken()->tokentype != IT_EOL)
				return (-1);
			writes(tag);
			writes(" OK Folder directory unsubscribe punted.\r\n");
			return (0);
		}

		mailbox=my_strdup(curtoken->tokenbuf);

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(mailbox);
			return (-1);
		}

		dir=valid_mailbox_name(mailbox, 1);

		if (dir && !is_sharedsubdir(dir))
		{
			unsubscribe(mailbox);
			free(mailbox);
			free(dir);
			writes(tag);
			writes(" OK Folder unsubscribed.\r\n");
			return (0);
		}

		if (dir && (*dir == 0 || access(dir, 0)))
		{
			free(dir);
			free(mailbox);
			writes(tag);
			writes(" OK Already unsubscribed.\r\n");
			return (0);
		}

		fetch_free_cache();
		if (!dir || maildir_shared_unsubscribe(0, mailbox+7))
		{
			free(mailbox);
			writes(tag);
			writes(" NO Cannot subscribe to this folder.\r\n");
			return (0);
		}
		free(dir);
		free(mailbox);
		writes(tag);
		writes(" OK UNSUBSCRIBE completed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "NAMESPACE") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)
			return (-1);
		writes("* NAMESPACE ((\"INBOX.\" \".\")) NIL ((\""
			SHARED ".\" \".\"))\r\n");
		writes(tag);
		writes(" OK NAMESPACE completed.\r\n");
		return (0);
	}

	/* mailbox commands */

	if (current_mailbox == 0)	return (-1);

	if (strcmp(curtoken->tokenbuf, "UID") == 0)
	{
		uid=1;
		if ((curtoken=nexttoken())->tokentype != IT_ATOM)
			return (-1);
		if (strcmp(curtoken->tokenbuf, "COPY") &&
			strcmp(curtoken->tokenbuf, "FETCH") &&
			strcmp(curtoken->tokenbuf, "SEARCH") &&
			strcmp(curtoken->tokenbuf, "THREAD") &&
			strcmp(curtoken->tokenbuf, "SORT") &&
			strcmp(curtoken->tokenbuf, "STORE"))
			return (-1);
	}

	if (strcmp(curtoken->tokenbuf, "CLOSE") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)
			return (-1);

		if (!current_mailbox_ro)
			expunge();
		free(current_mailbox);
		imapscan_free(&current_mailbox_info);
		current_mailbox=0;
		writes(tag);
		writes(" OK mailbox closed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "FETCH") == 0)
	{
	struct fetchinfo *fi;
	char	*msgset;

		curtoken=nexttoken();
		if (!ismsgset(curtoken))	return (-1);
		msgset=my_strdup(curtoken->tokenbuf);

		if ((curtoken=nexttoken())->tokentype != IT_LPAREN)
		{
			if (curtoken->tokentype != IT_ATOM)
			{
				free(msgset);
				return (-1);
			}
			fi=fetchinfo_alloc(1);
		}
		else
		{
			(void)nexttoken();
			fi=fetchinfo_alloc(0);
			if (fi && currenttoken()->tokentype != IT_RPAREN)
			{
				fetchinfo_free(fi);
				fi=0;
			}
			nexttoken();
		}

		if (fi == 0 || currenttoken()->tokentype != IT_EOL)
		{
			free(msgset);
			if (fi)	fetchinfo_free(fi);
			return (-1);
		}

		do_msgset(msgset, &do_fetch, fi, uid);
		fetchinfo_free(fi);
		free(msgset);
		writes(tag);
		writes(" OK FETCH completed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "STORE") == 0)
	{
	char	*msgset;
	struct storeinfo storeinfo_s;

		curtoken=nexttoken();
		if (!ismsgset(curtoken))	return (-1);
		msgset=my_strdup(curtoken->tokenbuf);

		(void)nexttoken();
		if (storeinfo_init(&storeinfo_s) ||
			currenttoken()->tokentype != IT_EOL)
		{
			free(msgset);
			return (-1);
		}

		/* Do not change \Deleted if this is a readonly mailbox */

		if (current_mailbox_ro && storeinfo_s.flags.deleted)
		{
			free(msgset);
			writes(tag);
			writes(" NO Current box is selected READ-ONLY.\r\n");
			return (0);
		}

		fetch_free_cache();
		if (do_msgset(msgset, &do_store, &storeinfo_s, uid))
		{
			writes(tag);
			writes(" NO [ALERT] You exceeded your mail quota.\r\n");
			free(msgset);
			return (0);
		}
		free(msgset);
		writes(tag);
		writes(" OK STORE completed.\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "SEARCH") == 0)
	{
	char *charset=0;
	const struct unicode_info *mycharset;
	struct searchinfo *si, *sihead;
	unsigned long i;

		curtoken=nexttoken_okbracket();
		if (curtoken->tokentype == IT_ATOM &&
			strcmp(curtoken->tokenbuf, "CHARSET") == 0)
		{
			curtoken=nexttoken();
			if (curtoken->tokentype != IT_ATOM &&
				curtoken->tokentype != IT_QUOTED_STRING)
				return (-1);

			charset=my_strdup(curtoken->tokenbuf);
			curtoken=nexttoken();
		}
		if ((si=alloc_parsesearch(&sihead)) == 0)
		{
			if (charset)	free(charset);
			return (-1);
		}
		if (currenttoken()->tokentype != IT_EOL)
		{
			if (charset)	free(charset);
			free_search(sihead);
			return (-1);
		}

		mycharset=unicode_find(charset);

		if (!mycharset)
		{
			writes(tag);
			writes(" NO ");
			writes(charset);
			writes(" character set is not supported.\r\n");
			if (charset)	free(charset);
			free_search(sihead);
			return (0);
		}

		if (charset)
			free(charset);
#if 0
		writes("* OK ");
		debug_search(si);
		writes("\r\n");
#endif
		writes("* SEARCH");
		dosearch(si, sihead, mycharset, uid);
		writes("\r\n");

		for (i=0; i<current_mailbox_info.nmessages; i++)
			if (current_mailbox_info.msgs[i].changedflags)
				fetchflags(i);
		writes(tag);
		writes(" OK SEARCH done.\r\n");
		free_search(sihead);
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "THREAD") == 0)
	{
	char *charset=0;
	struct searchinfo *si, *sihead;
	unsigned long i;
	const struct unicode_info *mycharset;

		/* The following jazz is mainly for future extensions */

	void (*thread_func)(struct searchinfo *, struct searchinfo *,
			    const struct unicode_info *, int);
	search_type thread_type;

		{
		const char *p=getenv("IMAP_DISABLETHREADSORT");
		int n= p ? atoi(p):0;

			if (n > 0)
			{
				writes(tag);
				writes(" NO This command is disabled by the system administrator.\r\n");
				return (0);
			}
		}

		curtoken=nexttoken();
		if (curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		if (strcmp(curtoken->tokenbuf, "ORDEREDSUBJECT") == 0)
		{
			thread_func=dothreadorderedsubj;
			thread_type=search_orderedsubj;
		}
		else if (strcmp(curtoken->tokenbuf, "REFERENCES") == 0)
		{
			thread_func=dothreadreferences;
			thread_type=search_references1;
		}
		else
		{
			return (-1);
		}

		curtoken=nexttoken();
		if (curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
			return (-1);

		charset=my_strdup(curtoken->tokenbuf);
		curtoken=nexttoken();

		if ((si=alloc_parsesearch(&sihead)) == 0)
		{
			if (charset)	free(charset);
			return (-1);
		}

		si=alloc_searchextra(si, &sihead, thread_type);

		if (currenttoken()->tokentype != IT_EOL)
		{
			if (charset)	free(charset);
			free_search(sihead);
			return (-1);
		}

		mycharset=unicode_find(charset);
		if (!mycharset)
		{
			writes(tag);
			writes(" NO ");
			writes(charset);
			writes(" character set is not supported.\r\n");

			free(charset);
			free_search(sihead);
			return (0);
		}
		free(charset);

		writes("* THREAD ");
		(*thread_func)(si, sihead, mycharset, uid);
		writes("\r\n");

		for (i=0; i<current_mailbox_info.nmessages; i++)
			if (current_mailbox_info.msgs[i].changedflags)
				fetchflags(i);
		writes(tag);
		writes(" OK THREAD done.\r\n");
		free_search(sihead);
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "SORT") == 0)
	{
	char *charset=0;
	struct searchinfo *si, *sihead;
	unsigned long i;
	struct temp_sort_stack *ts=0;
	const struct unicode_info *mycharset;

		{
		const char *p=getenv("IMAP_DISABLETHREADSORT");
		int n= p ? atoi(p):0;

			if (n > 0)
			{
				writes(tag);
				writes(" NO This command is disabled by the system administrator.\r\n");
				return (0);
			}
		}

		curtoken=nexttoken();
		if (curtoken->tokentype != IT_LPAREN)	return (-1);
		while ((curtoken=nexttoken())->tokentype != IT_RPAREN)
		{
		search_type st;
		struct temp_sort_stack *newts;

			if (curtoken->tokentype != IT_ATOM &&
				curtoken->tokentype != IT_QUOTED_STRING)
			{
				free_temp_sort_stack(ts);
				return (-1);
			}

			if (strcmp(curtoken->tokenbuf, "SUBJECT") == 0)
			{
				st=search_orderedsubj;
			}
			else if (strcmp(curtoken->tokenbuf, "ARRIVAL") == 0)
			{
				st=search_arrival;
			}
			else if (strcmp(curtoken->tokenbuf, "CC") == 0)
			{
				st=search_cc;
			}
			else if (strcmp(curtoken->tokenbuf, "DATE") == 0)
			{
				st=search_date;
			}
			else if (strcmp(curtoken->tokenbuf, "FROM") == 0)
			{
				st=search_from;
			}
			else if (strcmp(curtoken->tokenbuf, "REVERSE") == 0)
			{
				st=search_reverse;
			}
			else if (strcmp(curtoken->tokenbuf, "SIZE") == 0)
			{
				st=search_size;
			}
			else if (strcmp(curtoken->tokenbuf, "TO") == 0)
			{
				st=search_to;
			}
			else
			{
				free_temp_sort_stack(ts);
				return (-1);
			}

			newts=(struct temp_sort_stack *)malloc(
				sizeof(struct temp_sort_stack));
			if (!newts)	write_error_exit(0);
			newts->next=ts;
			newts->type=st;
			ts=newts;
		}

		if (ts == 0	/* No criteria */
			|| ts->type == search_reverse)
				/* Can't end with the REVERSE keyword */
		{
			free_temp_sort_stack(ts);
			return (-1);
		}

		curtoken=nexttoken();
		if (curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
		{
			free_temp_sort_stack(ts);
			return (-1);
		}

		charset=my_strdup(curtoken->tokenbuf);
		curtoken=nexttoken();

		if ((si=alloc_parsesearch(&sihead)) == 0)
		{
			if (charset)	free(charset);
			free_temp_sort_stack(ts);
			return (-1);
		}

		while (ts)
		{
		struct temp_sort_stack *cts=ts;

			ts=cts->next;
			si=alloc_searchextra(si, &sihead, cts->type);
			free(cts);
		}

		if (currenttoken()->tokentype != IT_EOL)
		{
			if (charset)	free(charset);
			free_search(sihead);
			return (-1);
		}

		mycharset=unicode_find(charset);

		if (!mycharset)
		{
			writes(tag);
			writes(" NO ");
			writes(charset);
			writes(" character set is not supported.\r\n");

			if (charset) free(charset);
			free_search(sihead);
			return (0);
		}
		free(charset);

		writes("* SORT");
		dosortmsgs(si, sihead, mycharset, uid);
		writes("\r\n");

		for (i=0; i<current_mailbox_info.nmessages; i++)
			if (current_mailbox_info.msgs[i].changedflags)
				fetchflags(i);
		writes(tag);
		writes(" OK SORT done.\r\n");
		free_search(sihead);
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "CHECK") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		noop();
		writes(tag);
		writes(" OK CHECK completed\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "EXPUNGE") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		expunge();
		noop();
		writes(tag);
		writes(" OK EXPUNGE completed\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "COPY") == 0)
	{
	char	*mailbox;
	char	*msgset;
	struct copyquotainfo cqinfo;
	char	quotabuf[QUOTABUFSIZE];
	int	has_quota;
	int	isshared;

		curtoken=nexttoken();
		if (!ismsgset(curtoken))	return (-1);
		msgset=my_strdup(curtoken->tokenbuf);

		curtoken=nexttoken_nouc();

		if (curtoken->tokentype != IT_NUMBER &&
			curtoken->tokentype != IT_ATOM &&
			curtoken->tokentype != IT_QUOTED_STRING)
		{
			free(msgset);
			return (-1);
		}

		mailbox=decode_valid_mailbox(curtoken->tokenbuf, 1);

		if (!mailbox)
		{
			free(msgset);

			mailbox=valid_mailbox_name(curtoken->tokenbuf, 1);
			if (mailbox && *mailbox == 0)
			{
				free(mailbox);
				mailbox=0;
			}
			if (mailbox && nexttoken()->tokentype == IT_EOL)
			{
				free(mailbox);
				writes(tag);
				writes(" NO [TRYCREATE] Mailbox does not exist.\r\n");
				return (0);
			}
			if (mailbox)	free(mailbox);
			return (-1);
		}

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(msgset);
			return (-1);
		}

		if (access(mailbox, 0))
		{
			writes(tag);
			writes(" NO [TRYCREATE] Mailbox does not exist.\r\n");
			free(msgset);
			free(mailbox);
			return (0);
		}

		fetch_free_cache();
		cqinfo.destmailbox=mailbox;

		/*
		** If the destination is a shared folder, copy it into the
		** real shared folder.
		*/

		isshared=0;
		if (is_sharedsubdir(cqinfo.destmailbox))
		{
		char	*p=malloc(strlen(cqinfo.destmailbox)+sizeof("/shared"));

			if (!p)	write_error_exit(0);
			strcat(strcpy(p, cqinfo.destmailbox), "/shared");

			free(mailbox);
			mailbox=cqinfo.destmailbox=p;
			isshared=1;
		}

		cqinfo.nbytes=0;
		cqinfo.nfiles=0;

		has_quota=0;
		if (!isshared && maildir_getquota(mailbox, quotabuf) == 0)
		{
			has_quota=1;
			if (do_msgset(msgset, &do_copy_quota_calc, &cqinfo,
					uid))
				has_quota= -1;
		}
		if (has_quota > 0 && cqinfo.nfiles > 0)
		{
		int	quotafd;

			if (maildir_checkquota(mailbox, &quotafd,
				quotabuf, cqinfo.nbytes, cqinfo.nfiles)
				&& errno != EAGAIN)
			{
				if (quotafd >= 0)	close(quotafd);
				writes(tag);
				writes(
			" NO [ALERT] You exceeded your mail quota.\r\n");
				free(msgset);
				free(mailbox);
				return (0);
			}

			maildir_addquota(mailbox, quotafd, quotabuf,
				cqinfo.nbytes, cqinfo.nfiles);
			if (quotafd >= 0)	close(quotafd);
		}

		if (has_quota < 0 ||
			do_msgset(msgset, &do_copy, mailbox, uid))
		{
			writes(tag);
			writes(" NO [ALERT] COPY failed - no write permission or out of disk space.\r\n");
			return (0);
		}

		writes(tag);
		writes(" OK COPY completed.\r\n");
		free(msgset);
		free(mailbox);
		return (0);
	}
	return (-1);
}

static void dogethostname()
{
char	buf[2048];
char	*p;

	if (gethostname(buf, sizeof(buf)) < 0)
		strcpy(buf, "courier-imap");
	p=malloc(strlen(buf)+sizeof("HOSTNAME="));
	if (!p)
		write_error_exit(0);
	strcat(strcpy(p, "HOSTNAME="), buf);
	putenv(p);
}

#if 0
static char *getcurdir()
{
char	*pathbuf=0;
size_t	pathlen=256;

	for (;;)
	{
		if ((pathbuf=pathbuf ? realloc(pathbuf, pathlen):
			malloc(pathlen)) == 0)
			write_error_exit(0);
		if (getcwd(pathbuf, pathlen-1))
			return (pathbuf);
		if (errno != ERANGE)
		{
			free(pathbuf);
			return (0);
		}
		pathlen += 256;
	}
}

static char *getimapscanpath(const char *argv0)
{
char	*p, *q;

	if (*argv0 != '/')
	{
		p=getcurdir();
		if (!p)
		{
			perror("getcwd");
			exit(1);
		}
		q=malloc(strlen(p)+strlen(argv0)+sizeof("//imapscan"));
		if (!q)	write_error_exit(0);
		strcat(strcat(strcpy(q, p), "/"), argv0);
	}
	else
	{
		q=malloc(strlen(argv0)+sizeof("imapscan"));
		if (!q)	write_error_exit(0);
		strcpy(q, argv0);
	}
	p=strrchr(q, '/');
	if (p && p[1] == 0)
	{
		*p=0;
		p=strrchr(q, '/');
	}
	
	if (p)
		p[1]=0;
	else	*q=0;

	strcat(q, "imapscan");
	return (q);
}
#endif

int main(int argc, char **argv)
{
const char *ip;
const char *p;
const char *tag;

	if ((tag=getenv("IMAPLOGINTAG")) != 0)
		authmodclient();
	else
	{
		putenv("TCPREMOTEIP=127.0.0.1");
		putenv("AUTHENTICATED=user");
	}

#if HAVE_SETLOCALE
	setlocale(LC_CTYPE, "C");
#endif

	ip=getenv("TCPREMOTEIP");
	if (!ip || !*ip)	exit(0);

	putenv("IMAP_STARTTLS=NO");	/* No longer grok STARTTLS */

	fprintf(stderr, "INFO: LOGIN, user=%s, ip=[%s]\n",
		getenv("AUTHENTICATED"), ip);

	{
	struct	stat	buf;

		if ( stat(".", &buf) < 0 || buf.st_mode & S_ISVTX)
		{
			fprintf(stderr, "INFO: LOCKED, user=%s, ip=[%s]\n",
				getenv("AUTHENTICATED"), ip);
			writes("* BYE Your account is temporarily unavailable (+t bit set on home directory).\r\n");
			writeflush();
			exit(0);
		}
	}

	p=getenv("MAILDIR");

	if ((p == 0 || *p == 0) && argc > 1)	p=argv[1];
#if 0
	imapscanpath=getimapscanpath(argv[0]);
#endif
	if (p && *p && chdir(p))
		write_error_exit(p);

	p=getenv("HOSTNAME");
	if (!p)
		dogethostname();

	mdcreate("." TRASH);
#if 0
	mdcreate("." DRAFTS);
#endif

	if ((p=getenv("IMAPDEBUGFILE")) != 0 && *p)
		debugfile=fopen(p, "a");

	emptytrash();
	if ((tag=getenv("IMAPLOGINTAG")) != 0)
	{
		writes(tag);
		writes(" OK LOGIN Ok.\r\n");
	}
	else
		writes("* PREAUTH Ready.\r\n");
	writeflush();
	mainloop();
	return (0);
}
