/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"rfc1035.h"
#include	<string.h>
#include	<errno.h>
#include	"rfc1035_res.h"

static const char rcsid[]="$Id: rfc1035qptr.c,v 1.5 2000/05/28 16:58:28 mrsam Exp $";

static int ptr(struct rfc1035_res *, const void *, int, char *);

/* Convenient function to do reverse IP lookup */
#if	RFC1035_IPV6

int rfc1035_ptr(struct rfc1035_res *res, const RFC1035_ADDR *addr, char *name)
{
struct	in_addr	in4;

#if 0

	if (ptr(res, addr, AF_INET6, name) == 0)	return (0);
	/* BUG: check errno */

	if (!IN6_IS_ADDR_V4MAPPED(addr))	return (-1);

	rfc1035_ipv6to4(&in4, addr);
	return (ptr(res, &in4, AF_INET, name));
#else
	if (IN6_IS_ADDR_V4MAPPED(addr))
	{
		rfc1035_ipv6to4(&in4, addr);
		if (ptr(res, &in4, AF_INET, name) == 0)	return (0);
		if (errno != ENOENT)			return (-1);
	}
	return (ptr(res, addr, AF_INET6, name));
#endif
}

#else
int rfc1035_ptr(struct rfc1035_res *res, const RFC1035_ADDR *a, char *name)
{
	return (ptr(res, a, AF_INET, name));
}
#endif

static int ptr(struct rfc1035_res *res, const void *addr, int af, char *name)
{
struct	rfc1035_reply *reply;
int	n;

#if	RFC1035_IPV6

	if (af == AF_INET6)
	{
	const char *sin6=(const char *)addr;
	unsigned i;

		*name=0;
		for (i=sizeof(struct in6_addr); i; )
		{
		char	buf[10];

			--i;
			sprintf(buf, "%x.%x.",
				(int)(unsigned char)(sin6[i] & 0x0F),
				(int)(unsigned char)((sin6[i] >> 4) & 0x0F));
			strcat(name, buf);
		}
		strcat(name, "ip6.int");
	}
	else
#endif
	if (af != AF_INET)
	{
		errno=ENOENT;
		return (-1); /* hard error */
	}
	else
	{
	const char *p;
	unsigned char a=0,b=0,c=0,d=0;
	struct	in_addr	ia;

		memcpy(&ia, addr, sizeof(ia));
		rfc1035_ntoa_ipv4(&ia, name);
		p=name;

		while (*p >= '0' && *p <= '9')
			a= (int)a * 10 + (*p++ - '0');
		if (*p)	p++;
		while (*p >= '0' && *p <= '9')
			b= (int)b * 10 + (*p++ - '0');
		if (*p)	p++;
		while (*p >= '0' && *p <= '9')
			c= (int)c * 10 + (*p++ - '0');
		if (*p)	p++;
		while (*p >= '0' && *p <= '9')
			d= (int)d * 10 + (*p++ - '0');

		sprintf(name, "%d.%d.%d.%d.in-addr.arpa",
			(int)d, (int)c, (int)b, (int)a);
	}

	if (rfc1035_resolve_cname(res, RFC1035_RESOLVE_RECURSIVE, name,
		RFC1035_TYPE_PTR, RFC1035_CLASS_IN, &reply) < 0 ||
		reply == 0 ||
		(n=rfc1035_replysearch_all( reply, name, RFC1035_TYPE_PTR,
			RFC1035_CLASS_IN, 0)) < 0 ||
		rfc1035_replyhostname(reply, reply->allrrs[n]->rr.domainname,
			name) == 0)
	{
		if (reply && reply->rcode != RFC1035_RCODE_NXDOMAIN &&
			reply->rcode != RFC1035_RCODE_NOERROR)
		{
			rfc1035_replyfree(reply);
			errno=EAGAIN;
			return (-1);
		}

		if (reply) rfc1035_replyfree(reply);
		errno=ENOENT;
		return (-1); /* hard error */
	}

	rfc1035_replyfree(reply);
	return (0);
}
