#ifndef	maildirfilter_h
#define	maildirfilter_h

/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char maildirfilter_h_rcsid[]="$Id: maildirfilter.h,v 1.4 2000/12/02 05:38:53 mrsam Exp $";

#include	"config.h"

#ifdef __cplusplus
extern "C" {
#endif

enum maildirfiltertype {
	startswith,
	endswith,
	contains,
	hasrecipient,
	mimemultipart,
	textplain,
	islargerthan,		/* Use negation for the opposite! */
	} ;

struct maildirfilterrule {
	struct maildirfilterrule *next, *prev;
	char *rulename;
	enum maildirfiltertype type;
	int flags;

#define	MFR_DOESNOT	1	/* Negates pretty much every condition */
#define	MFR_BODY	2	/* startswith/endswith/contains applied
				** to body.
				*/
#define	MFR_CONTINUE	4	/* Continue filtering (cc instead of to) */

	char *fieldname;
	char *fieldvalue;
	char *tofolder;
	} ;

struct maildirfilter {
	struct maildirfilterrule *first, *last;
	} ;

/****************************************************************************/
/*             Low-level filter access functions                            */
/****************************************************************************/

/*
** A maildirfilter structure is initialized simply by nulling it out, then: */

struct maildirfilterrule *mf_appendrule(struct maildirfilter *,
	const char *,
	enum maildirfiltertype,
	int,
	const char *,
	const char *,
	const char *,
	int *);		/* Append a new rule */

/* Move a given rule up or down in the hierarchy */

void mf_ruleup(struct maildirfilter *, struct maildirfilterrule *);
void mf_ruledown(struct maildirfilter *, struct maildirfilterrule *);

/* Delete a given rule */

void mf_ruledel(struct maildirfilter *, struct maildirfilterrule *);

/* Update an existing rule */

int mf_ruleupdate(struct maildirfilter *, struct maildirfilterrule *,
	const char *,
        enum maildirfiltertype,
	int,
        const char *,
        const char *,
        const char *,
	int *);

#define	mf_freerules(r)	do { \
	while ( (r)->first )	\
		mf_ruledel( (r), (r)->first );	\
	} while (0)


/*
** mf_appendrule and mf_ruleupdate set err_code to the following upon an error
** exit
*/

#define	MF_ERR_BADRULENAME	1
#define	MF_ERR_BADRULETYPE	2
#define	MF_ERR_BADRULEHEADER	3
#define	MF_ERR_BADRULEVALUE	4
#define	MF_ERR_BADRULEFOLDER	5
#define MF_ERR_INTERNAL		100

/* Save/Load rules from the given file */

int mf_saverules(struct maildirfilter *,
		 const char *,		/* Filename */
		 const char *,		/* Maildir */
		 const char *,		/* Path to maildir from mailfilter */
		 const char *);		/* The return address */

int mf_loadrules(struct maildirfilter *, const char *);

#define	MF_LOADOK	0
#define	MF_LOADNOTFOUND	1
#define	MF_LOADFOREIGN	2
#define	MF_LOADERROR	3

/****************************************************************************/
/*             High-level filter access functions                            */
/****************************************************************************/

int mf_importmaildirfilter(const char *); /* Get the maildir filter */
int mf_loadmaildirfilter(struct maildirfilter *, const char *);
int mf_savemaildirfilter(struct maildirfilter *, const char *, const char *);
int mf_exportmaildirfilter(const char *);
						/* Commit the maildir filter */
int mf_hasmaildirfilter(const char *);		/* Is maildir filter defined? */

void mf_endmaildirfilter(const char *);		/* Remove the temp file */

#ifdef __cplusplus
}
#endif

#endif
