/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"imapwrite.h"

static const char rcsid[]="$Id: capability.c,v 1.4 2000/11/11 19:52:31 mrsam Exp $";

int have_starttls()
{
const char *p;

	if ((p=getenv("IMAP_STARTTLS")) == 0)	return (0);
	if (*p != 'y' && *p != 'Y')		return (0);

	p=getenv("COURIERTLS");
	if (!p || !*p)	return (0);
	if (access(p, X_OK))	return (0);
	return (1);
}


int tlsrequired()
{
const char *p=getenv("IMAP_TLS_REQUIRED");

	if (p && atoi(p))       return (1);
	return (0);
}


void capability()
{
const char *p;

	writes("* CAPABILITY ");

	if ((p=getenv("IMAP_TLS")) && atoi(p) &&
	    (p=getenv("IMAP_CAPABILITY_TLS")) && *p)
		writes(p);
	else if ((p=getenv("IMAP_CAPABILITY")) != 0 && *p)
		writes(p);
	else
		writes("IMAP4rev1");

	if (have_starttls())
	{
		writes(" STARTTLS");
		if (tlsrequired())
			writes(" LOGINDISABLED");
	}
	writes("\r\n");
}
