#include	<stdlib.h>
#include	"rfc2045/rfc2045.h"

static char *write_challenge_buf;
static char *write_challenge_ptr;

static void write_challenge(const char *p, size_t l)
{
	while (l)
	{
		if (*p == '\r' || *p == '\n')
		{
			++p;
			--l;
			continue;
		}
		*write_challenge_ptr++ = *p++;
		--l;
	}
}

char *authsasl_tobase64(const char *p, int l)
{
	if (l < 0)	l=strlen(p);

	write_challenge_buf=malloc((l+3)/3*4+1);
	if (!write_challenge_buf)
		return (0);

	write_challenge_ptr=write_challenge_buf;

	rfc2045_base64encode_start( &write_challenge );
	rfc2045_base64encode(p, l);
	rfc2045_base64encode_end();
	*write_challenge_ptr=0;
	return (write_challenge_buf);
}
