/*
** Copyright 2000 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#include	"auth.h"
#include	"authmod.h"
#include	"authstaticlist.h"
#include	"authsasl.h"
#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<errno.h>
#include	"numlib/numlib.h"

static const char rcsid[]="$Id: authdaemon.c,v 1.4 2000/10/05 04:15:41 mrsam Exp $";

extern int authdaemondo(const char *authreq,
	int (*func)(struct authinfo *, void *), void *arg);

static int callback(struct authinfo *a, void *p)
{
char	*username;

        if ((*(char **)p=username=strdup(a->address)) == 0)
        {
                perror("malloc");
                return (1);
        }

        {
	static  char *prevp=0;
	const char *cp=a->maildir;
	char    *p;

		if (!cp)        cp="";
		p=malloc(sizeof("MAILDIR=")+strlen(cp));
		if (!p)
		{
			perror("malloc");
			free(username);
			return (1);
		}
		strcat(strcpy(p, "MAILDIR="), cp);
		putenv(p);
		if (prevp)      free(prevp);
		prevp=p;
	}

	if (a->sysusername && a->sysuserid)
		a->sysusername=0;

	authsuccess(a->homedir, a->sysusername, a->sysuserid, &a->sysgroupid,
                a->address, a->fullname);

        return (0);
}

char *auth_daemon(const char *service, const char *authtype, char *authdata,
        int issession,
	void (*callback_func)(struct authinfo *, void *), void *callback_arg)

{
char	tbuf[NUMBUFSIZE];
size_t	l=strlen(service)+strlen(authtype)+strlen(authdata)+1;
char	*n=str_size_t(l, tbuf);
char	*buf=malloc(strlen(n)+l+20);
int	rc;
char	*username=0;

	if (!buf)
	{
		perror("malloc");
		errno=EACCES;
		return (0);
	}
	strcat(strcat(strcpy(buf, "AUTH "), n), "\n");
	strcat(strcat(buf, service), "\n");
	strcat(strcat(buf, authtype), "\n");
	strcat(buf, authdata);
	rc=authdaemondo(buf, callback, &username);
	free(buf);

        if (rc < 0)
        {
                errno=EPERM;
                return (0);
        }
        if (rc > 0)
        {
                errno=EACCES;
                return (0);
        }

	return (username);
}

extern int auth_daemon_pre(const char *uid, const char *service,
        int (*callback)(struct authinfo *, void *),
		    void *arg);

extern void auth_daemon_cleanup();

struct authstaticinfo authdaemon_info={
	"authdaemon",
	auth_daemon,
	auth_daemon_pre,
	auth_daemon_cleanup,
	0};
