#
#  Need to version-upgrade RH builds due to different directory locations.
#

%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; echo "$release")
Summary: Courier-IMAP 1.1 IMAP server
Name: courier-imap
Version: 1.1
Release: 1%{courier_release}
Copyright: GPL
Group: Applications/Mail
Source: courier-imap-1.1.tar.gz
Packager: %{PACKAGER}
BuildRoot: /var/tmp/courier-imap-install
Requires: /sbin/chkconfig

#  RH 7.0 resets sysconfdir & mandir, put them back where they belong

%define _sysconfdir %{_prefix}/etc
%define	_mandir %{_prefix}/man

%define	_prefix	/usr/lib/courier-imap

%define _localstatedir /var/run

%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)

%define	authdaemondir	%{_localstatedir}/authdaemon.courier-imap

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.  This package contains
the standalone version of the IMAP server that's included in the Courier
mail server package.  This package is a standalone version for use with
other mail servers.  Do not install this package if you intend to install the
full Courier mail server.  Install the Courier package instead.
%prep
%setup

%configure --localstatedir=%{_localstatedir} \
	--with-authdaemonvar=%{authdaemondir}

%build
make
make check
%install

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
make install-strip DESTDIR=$RPM_BUILD_ROOT

#
# Red Hat init.d file
#

mkdir -p $RPM_BUILD_ROOT%{initdir}
cp courier-imap.sysvinit $RPM_BUILD_ROOT%{initdir}/courier-imap

#
# Fix imapd.config
#

sed 's/^IMAPDSTART=.*/IMAPDSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config.tmp

mv $RPM_BUILD_ROOT%{_sysconfdir}/imapd.config.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config

sed 's/^IMAPDSSLSTART=.*/IMAPDSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config.tmp

mv $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config

chmod 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd.config
chmod 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config

#
# Red Hat /etc/profile.d scripts
#

mkdir -p $RPM_BUILD_ROOT/etc/profile.d
cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.sh <<EOF
if echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}
then
	:
else
	MANPATH="%{_mandir}:\$MANPATH"
	export MANPATH
	PATH="%{_bindir}:\$PATH"
	if test -w /etc
	then
		PATH="%{_sbindir}:\$PATH"
	fi
	export PATH
fi
EOF

cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.csh <<EOF

if ( \$?MANPATH ) then
	true
else
	setenv MANPATH ""
endif

echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}

if ( \$? ) then
	true
else
	setenv MANPATH "%{_mandir}:\$MANPATH"
	setenv PATH "%{_bindir}:\$PATH"
	test -w /etc
	if ( \$? ) then
		true
	else
		setenv PATH "%{_sbindir}:\$PATH"
	endif
endif
EOF

#
# Compress everything in man
#

find $RPM_BUILD_ROOT%{_mandir} ! -type d -print | perl -e '

	while (<>)
	{
		chop if /\n$/;
		next if /\.gz$/;
		$file=$_;
		if ( -l $file)
		{
                        symlink readlink("$file")
                                . ".gz", "$file.gz";
			unlink($file);
                }
                else
                {
                        system("gzip <$file >$file.gz");
			unlink($file);
		}
	}
'

cp imap/README README.imap
cp maildir/README.maildirquota.txt README.maildirquota
cp maildir/README.sharedfolders.txt README.sharedfolders

#
#  Check if authdaemond was installed, make sure to include authdaemon
#  directory
#

cp /dev/null authdaemon.files

. authlib/authdaemonrc

if test "$authdaemonvar" != ""
then
	echo '%dir %attr(700, root, root) ' $authdaemonvar >authdaemon.files
	touch $RPM_BUILD_ROOT/$authdaemonvar/lock || exit 1
	touch $RPM_BUILD_ROOT/$authdaemonvar/pid || exit 1
	authlib/authmksock $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	chmod 777 $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	echo '%ghost %attr(600, root, root) ' $authdaemonvar/lock >>authdaemon.files
	echo '%ghost %attr(644, root, root) ' $authdaemonvar/pid >>authdaemon.files
	echo '%ghost %attr(-, root, root) ' $authdaemonvar/socket >>authdaemon.files
fi

mkdir -p $RPM_BUILD_ROOT%{_localstatedir}
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid.lock
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid.lock

%post
/sbin/chkconfig --del courier-imap
/sbin/chkconfig --add courier-imap

%preun

if test "$1" = "0"
then
	/sbin/chkconfig --del courier-imap
fi

%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop

%files -f authdaemon.files
%defattr(-, bin, bin)
%config /etc/pam.d/imap
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.csh
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.sh
%attr(755, bin, bin) %{initdir}/courier-imap
%dir %{_prefix}

%if "%{_prefix}" != "%{_exec_prefix}"
%dir %{_exec_prefix}
%endif

%{_libexecdir}
%config %{_sysconfdir}
%{_bindir}
%{_sbindir}
%{_mandir}
%{_datadir}

%doc AUTHORS COPYING imap/BUGS README README.imap README.maildirquota
%doc imap/FAQ imap/FAQ.html README.sharedfolders authlib/README.*

%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid.lock
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid.lock

%clean
rm -rf $RPM_BUILD_ROOT
