/*
** Copyright 1998 - 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if	HAVE_SYS_WAIT_H
#include	<sys/wait.h>
#endif

#include	"imaptoken.h"
#include	"imapwrite.h"

#include	"authlib/auth.h"
#include	"authlib/authmod.h"
#include	"tcpd/spipe.h"

static const char rcsid[]="$Id: imaplogin.c,v 1.6 2000/07/23 02:45:48 mrsam Exp $";

FILE *debugfile=0;
extern void mainloop();
extern void capability();
extern int have_starttls();
extern int tlsrequired();
extern int authenticate(const char *);

int main_argc;
char **main_argv;

void rfc2045_error(const char *p)
{
	write(2, p, strlen(p));
	_exit(0);
}

static int	starttls(const char *tag)
{
int	pipefd[2];
pid_t	p;
int	waitstat;

	if (s_pipe(pipefd))
	{
		writes(tag);
		writes(" NO s_pipe() failed.");
		return (-1);
	}

	p=fork();
	if (p == -1)
	{
		writes(tag);
		writes(" NO fork() failed.");
		return (-1);
	}

	if (p == 0)
	{
	char	buf1[100];
	char	dummy;

		/*
		** Fork once more, and let the parent exit,
		** so that courieresmtpd doesn't have this
		** child process.
		*/

		p=fork();
		if (p == -1)
		{
			perror("fork");
			exit(1);
		}
		if (p)	exit(0);

		close(pipefd[0]);
		sprintf(buf1, "-localfd=%d", (int)pipefd[1]);
		if (read(pipefd[1], &dummy, 1) != 1)
			exit(0);

		/* couriertls will have the socket on fd 0,
		** and dup stderr on fd 1 */

		close(1);
		dup(2);
		execl( getenv("COURIERTLS"), "couriertls",
			buf1, "-tcpd", "-server", (char *)0);
	}

	writes(tag);
	writes(" OK Begin SSL/TLS negotation now.\r\n");
	writeflush();
	close(pipefd[1]);
	close(0);
	close(1);
	if (dup(pipefd[0]) != 0 || dup(pipefd[0]) != 1)
	{
		perror("dup");
		exit(1);
	}
	close(pipefd[0]);
	write(1, "", 1);	/* child - exec OK now */
	while (wait(&waitstat) != p)
		;
	return (0);
}

int do_imap_command(const char *tag)
{
struct	imaptoken *curtoken=nexttoken();

	if (strcmp(curtoken->tokenbuf, "LOGOUT") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)   return (-1);
		writes("* BYE Courier-IMAP server shutting down\r\n");
		writes(tag);
		writes(" OK LOGOUT completed\r\n");
		writeflush();
		fprintf(stderr, "INFO: LOGOUT, ip=[%s]\n",
			getenv("TCPREMOTEIP"));
		exit(0);
	}
	if (strcmp(curtoken->tokenbuf, "NOOP") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		writes(tag);
		writes(" OK NOOP completed\r\n");
		return (0);
	}
	if (strcmp(curtoken->tokenbuf, "CAPABILITY") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		capability();
		writes(tag);
		writes(" OK CAPABILITY completed\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "STARTTLS") == 0)
	{
		if (!have_starttls())	return (-1);
		if (starttls(tag))		return (-1);
		putenv("IMAP_STARTTLS=NO");
		putenv("IMAP_TLS_REQUIRED=0");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "LOGIN") == 0)
	{
	struct imaptoken *tok=nexttoken_nouc();
	char	*userid;
	char	*tagenv;
	char	*passwd;

		if (have_starttls() && tlsrequired())	/* Not yet */
		{
			writes(tag);
			writes(" NO STARTTLS required\r\n");
			return (0);
		}

		switch (tok->tokentype)	{
		case IT_ATOM:
		case IT_NUMBER:
		case IT_QUOTED_STRING:
			break;
		default:
			return (-1);
		}

		userid=strdup(tok->tokenbuf);
		if (!userid)
			write_error_exit(0);
		tok=nexttoken_nouc();
		switch (tok->tokentype)	{
		case IT_ATOM:
		case IT_NUMBER:
		case IT_QUOTED_STRING:
			break;
		default:
			free(userid);
			return (-1);
		}

		tagenv=malloc(sizeof("IMAPLOGINTAG=")+strlen(tag));
		if (!tagenv)	write_error_exit(0);
		strcat(strcpy(tagenv, "IMAPLOGINTAG="), tag);
		passwd=my_strdup(tok->tokenbuf);

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(tagenv);
			free(userid);
			free(passwd);
			return (-1);
		}
		putenv(tagenv);
		authmod_login(main_argc-1, main_argv+1, "imap",
			userid, passwd);
	}

	if (strcmp(curtoken->tokenbuf, "AUTHENTICATE") == 0)
	{
		if (have_starttls() && tlsrequired())	/* Not yet */
		{
			writes(tag);
			writes(" NO STARTTLS required\r\n");
			return (0);
		}
		return (authenticate(tag));
	}

	return (-1);
}

extern void ignorepunct();

int main(int argc, char **argv)
{
const char	*tag=getenv("IMAPLOGINTAG");
const char	*ip;

	ip=getenv("TCPREMOTEIP");
	if (!ip)	exit(9);

#if	IMAP_CLIENT_BUGS

	ignorepunct();

#endif

	if (authmoduser(argc, argv, 60, 5))
	{
		writes("* OK Courier-IMAP ready. Copyright 1998-2000 Double Precision, Inc.  See COPYING for distribution information.\r\n");
		fprintf(stderr, "INFO: Connection, ip=[%s]\n", ip);
	}
	else
	{
		writes(tag ? tag:"");
		writes(" NO Login failed.\r\n");
		fprintf(stderr, "ERR: LOGIN FAILED, ip=[%s]\n", ip);
	}

	writeflush();
	main_argc=argc;
	main_argv=argv;

	mainloop();
	return (0);
}
