#ifndef	searchinfo_h
#define	searchinfo_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char searchinfo_h_rcsid[]="$Id: searchinfo.h,v 1.3 2000/06/09 12:29:14 mrsam Exp $";

	/* Search keys */

typedef enum {
	search_messageset,
	search_all,
	search_keyword,	/* Includes ANSWERED DELETED DRAFT FLAGGED RECENT
			SEEN KEYWORD */

	search_not,	/* Logical NOT, used to implement UNANSWERED
			UNDELETED UNDRAFT UNFLAGGED UNKEYWORD UNSEEN */

	/* NOTE: NEW gets parsed as ( RECENT UNSEEN )  OLD gets parsed as
	NOT RECENT */

	search_and,
	search_or,


	search_header, /* Also used to implement BCC, CC, FROM, TO, SUBJECT */

	search_before,
	search_body,
	search_larger,
	search_on,
	search_sentbefore,
	search_senton,
	search_sentsince,
	search_since,
	search_smaller,
	search_text,
	search_uid,

	/*
	** search_orderedsubj is a dummy node that's allocated in order to
	** implement an ORDEREDSUBJ THREAD/SORT. as points to the stripped
	** subject from the message.
	*/

	search_orderedsubj,

	/*
	** And the following dummies are used for similar purposes for the
	** SORT command.
	*/

	search_arrival,
	search_cc,
	search_date,
	search_from,
	search_reverse,
	search_size,
	search_to

	} search_type;

/* This structure is used when doing content searching */

struct searchengineinfo {
	const char *string;
	unsigned *r;    /* Retry backoff indexes */
	unsigned i;
	} ;


/* A SEARCH request gets parsed into the following structure */

struct searchinfo {
	struct searchinfo *next;	/* Link list of all searchinfos */

	struct searchinfo *a, *b;	/* Nested search requests */

	search_type	type;

	char	*as, *bs;		/* As needed */

	int	value;	/* When evaluating: 0 - false, 1 - true, -1 - unknown */
			/* Not used in AND, OR, and NOT nodes */

	struct searchengineinfo sei;	/* Used when searching */

#define	search_reset(si)	((si)->sei.i=0)
#define	search_found(si)	((si)->sei.string[(si)->sei.i] == '\0')

#define search_step(sie,ch) do \
        {\
                if ( (sie)->sei.string[(sie)->sei.i]) \
                {\
                        for (;;) \
                        {\
                                if ( (sie)->sei.string[(sie)->sei.i] == (ch) )\
                                        { (sie)->sei.i++; break; }\
                                if ( (sie)->sei.i == 0) break;\
                                (sie)->sei.i=(sie)->sei.r[(sie)->sei.i];\
                        }\
                }\
        } while (0)
 

	} ;

void free_search(struct searchinfo *);
struct searchinfo *alloc_parsesearch(struct searchinfo **);
struct searchinfo *alloc_searchextra(struct searchinfo *,
	struct searchinfo **, search_type);
void debug_search(struct searchinfo *);


void dosearch(struct searchinfo *, struct searchinfo *, int);

void search_internal(struct searchinfo *, struct searchinfo *,
	int, void (*)(struct searchinfo *,
		struct searchinfo *, int, unsigned long, void *), void *);

#endif
