/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<string.h>
#include	<stdlib.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"imaptoken.h"
#include	"imapwrite.h"
#include	"authlib/auth.h"
#include	"authlib/authmod.h"
#include	"authlib/authsasl.h"
#include	"random128/random128.h"
#include	"rfc2045/rfc2045.h"

static const char rcsid[]="$Id: authenticate_auth.c,v 1.4 1999/12/13 03:36:03 mrsam Exp $";

extern int main_argc;
extern char **main_argv;

static char *send_auth_reply(const char *q)
{
struct imaptoken *tok;
char	*p;

	writes("+ ");
	writes(q);
	writes("\r\n");
	writeflush();
	read_timeout(SOCKET_TIMEOUT);
	tok=nexttoken_nouc();

	switch (tok->tokentype)	{
	case IT_ATOM:
	case IT_NUMBER:
		break;
	default:
		return (0);
	}
	p=my_strdup(tok->tokenbuf);
	if (!p)
	{
		perror("malloc");
		return (0);
	}

	if (nexttoken()->tokentype != IT_EOL)
	{
		free(p);
		fprintf(stderr, "Invalid SASL response\n");
		return (0);
	}
	return (p);
}

int authenticate(const char *tag)
{
struct imaptoken *tok=nexttoken();
char	*authmethod;
char	*initreply=0;
char	*tagenv;
char	*authtype, *authdata;

	switch (tok->tokentype)	{
	case IT_ATOM:
	case IT_QUOTED_STRING:
		break;
	default:
		return (-1);
	}

	authmethod=my_strdup(tok->tokenbuf);

	tok=nexttoken_nouc();
	if (tok->tokentype != IT_EOL)
	{
		switch (tok->tokentype)	{
		case IT_ATOM:
		case IT_NUMBER:
			break;
		default:
			return (-1);
		}
		initreply=my_strdup(tok->tokenbuf);
		tok=nexttoken_nouc();
	}

	if (tok->tokentype != IT_EOL)	return (-1);

	read_eol();
	if (authsasl(authmethod, initreply, &send_auth_reply,
		&authtype, &authdata))
	{
		free(authmethod);
		if (initreply)
			free(initreply);
		return (-1);
	}

	free(authmethod);
	if (initreply)
		free(initreply);

	tagenv=malloc(sizeof("IMAPLOGINTAG=")+strlen(tag));
	if (!tagenv)	write_error_exit(0);
	strcat(strcpy(tagenv, "IMAPLOGINTAG="), tag);
	putenv(tagenv);

	authmod(main_argc-1, main_argv+1, "imap",
		authtype, authdata);
	return (-1);
}
