Summary: Courier-IMAP 0.35 IMAP server
Name: courier-imap
Version: 0.35
Release: 1
Copyright: GPL
Group: Applications/Mail
Source: courier-imap-0.35.tar.gz
Packager: %{PACKAGER}
BuildRoot: /var/tmp/courier-imap-install
Requires: /sbin/chkconfig

%define	_prefix	/usr/lib/courier-imap

%define _localstatedir /var/run

%define	authdaemondir	%{_localstatedir}/authdaemon.courier-imap

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.

%prep
%setup

%configure --localstatedir=%{_localstatedir} \
	--with-authdaemonvar=%{authdaemondir}

%build
make
make check
%install

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
make install-strip DESTDIR=$RPM_BUILD_ROOT

#
# Red Hat init.d file
#

mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d

cat >$RPM_BUILD_ROOT/etc/rc.d/init.d/courier-imap <<EOF
#!/bin/sh
#
# chkconfig: 2345 80 30
# description: Courier-IMAP - IMAP server
#
#
#

case "\$1" in
start)
        cd /
	. %{_sysconfdir}/imapd.config
	touch /var/lock/subsys/courier-imap

	echo -n "Starting Courier-IMAP server:"
	case x\$IMAPDSTART in
	x[yY]*)
		# Start daemons.
		%{_libexecdir}/imapd.rc start
		;;
	esac

	. %{_sysconfdir}/imapd-ssl.config
	case x\$IMAPDSSLSTART in
	x[yY]*)
		test -x \$STUNNEL && %{_libexecdir}/imapd-ssl.rc start
		;;
	esac
	echo " imaplogin"
	;;
stop)
        echo -n "Stopping Courier-IMAP server:"
	%{_libexecdir}/imapd.rc stop
	%{_libexecdir}/imapd-ssl.rc stop
	echo " imaplogin"
	;;
restart)
	\$0 stop
	\$0 start
        ;;
esac
exit 0
EOF

#
# Fix imapd.config
#

sed 's/^IMAPDSTART=.*/IMAPDSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config.tmp

mv $RPM_BUILD_ROOT%{_sysconfdir}/imapd.config.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd.config

sed 's/^IMAPDSSLSTART=.*/IMAPDSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config.tmp

mv $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.config

#
# Red Hat /etc/profile.d scripts
#

mkdir -p $RPM_BUILD_ROOT/etc/profile.d
cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.sh <<EOF
if echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}
then
	:
else
	MANPATH="%{_mandir}:\$MANPATH"
	export MANPATH
	PATH="%{_bindir}:\$PATH"
	if test -w /etc
	then
		PATH="%{_sbindir}:\$PATH"
	fi
	export PATH
fi
EOF

cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.csh <<EOF

if ( \$?MANPATH ) then
	true
else
	setenv MANPATH ""
endif

echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}

if ( \$? ) then
	true
else
	setenv MANPATH "%{_mandir}:\$MANPATH"
	setenv PATH "%{_bindir}:\$PATH"
	test -w /etc
	if ( \$? ) then
		true
	else
		setenv PATH "%{_sbindir}:\$PATH"
	endif
endif
EOF

#
# Compress everything in man
#

find $RPM_BUILD_ROOT%{_mandir} ! -type d -print | perl -e '

	while (<>)
	{
		chop if /\n$/;
		next if /\.gz$/;
		$file=$_;
		if ( -l $file)
		{
                        symlink readlink("$file")
                                . ".gz", "$file.gz";
			unlink($file);
                }
                else
                {
                        system("gzip <$file >$file.gz");
			unlink($file);
		}
	}
'

cp imap/README README.imap
cp maildir/README.maildirquota.txt README.maildirquota
cp maildir/README.sharedfolders.txt README.sharedfolders

#
#  Check if authdaemond was installed, make sure to include authdaemon
#  directory
#

cp /dev/null authdaemon.files

. authlib/authdaemonrc

if test "$authdaemonvar" != ""
then
	echo '%dir %attr(700, root, root) ' $authdaemonvar >authdaemon.files
	touch $RPM_BUILD_ROOT/$authdaemonvar/lock || exit 1
	touch $RPM_BUILD_ROOT/$authdaemonvar/pid || exit 1
	authlib/authmksock $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	chmod 777 $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	echo '%ghost %attr(600, root, root) ' $authdaemonvar/lock >>authdaemon.files
	echo '%ghost %attr(644, root, root) ' $authdaemonvar/pid >>authdaemon.files
	echo '%ghost %attr(-, root, root) ' $authdaemonvar/socket >>authdaemon.files
fi

%post
/sbin/chkconfig --add courier-imap

%preun

if test "$1" = "0"
then
	/sbin/chkconfig --del courier-imap
fi

%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop

%files -f authdaemon.files
%defattr(-, bin, bin)
%config /etc/pam.d/imap
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.csh
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.sh
%attr(755, bin, bin) /etc/rc.d/init.d/courier-imap
%dir %{_prefix}

%if "%{_prefix}" != "%{_exec_prefix}"
%dir %{_exec_prefix}
%endif

%{_libexecdir}
%config %{_sysconfdir}
%{_bindir}
%{_sbindir}
%{_mandir}
%doc AUTHORS COPYING imap/BUGS README README.imap README.maildirquota
%doc imap/FAQ imap/FAQ.html README.sharedfolders authlib/README.*

%clean
rm -rf $RPM_BUILD_ROOT
