/*  $Id: ScriptController.h,v 1.6 2007/06/26 02:55:04 sarrazip Exp $
    ScriptController.h - Script-based game controller

    cosmosmash - A space rock shooting video game.
    Copyright (C) 2007 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_ScriptController
#define _H_ScriptController

#include "Controller.h"
#include "Command.h"

#include <iostream>


/** Format of version 1 of the game script file:
    Each line is a non-empty list of space-separated non negative integers.
    Line 1: format version number (1)
    Line 2: seed to pass to rand, converted to signed int
    Following lines: commands given in each tick, starting from tick 0.
*/
class ScriptController : public Controller
{
public:

    /** Reads the file to get its actual file format version
	and the seed for srand().
	Throws the int value -1 if this read operation fails.
	Throws -2 if the integers read are invalid (file format
	is expected to be positive decimal ASCII integer).
	Throws the actual file format version integer if it is
	not requiredFileFormatVersion.
    */
    ScriptController(std::istream &gameScriptStream,
		    int requiredFileFormatVersion);

    virtual ~ScriptController();

    /** Returns the seed read by the constructor, if it did not
	throw an exception.
    */
    unsigned getSeed() const;

    virtual void startOfTick();

    virtual bool isStartRequested(bool &isExtendedMode);

    virtual bool isEndRequested();

    virtual bool isPauseRequested();

    virtual bool isResumeRequested();

    virtual bool isShootingActive();

    virtual bool isHyperspaceRequested();

    virtual bool isLeftMoveRequested();

    virtual bool isRightMoveRequested();

private:

    std::istream &gameScriptStream;
    unsigned seed;
    bool start, end, pause, resume, left, right, shoot, hyperspace;

    // Forbidden operations:
    ScriptController(const ScriptController &x);
    ScriptController &operator = (const ScriptController &x);
};


#endif  /* _H_ScriptController */
